/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.phase;

import org.raml.yagi.framework.nodes.ArrayNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.phase.Transformer;
import org.raml.yagi.framework.util.NodeSelector;

public class RemoveTopLevelSequencesTransformer
implements Transformer {
    @Override
    public boolean matches(Node node) {
        return node.getParent() == null;
    }

    @Override
    public Node transform(Node node) {
        String[] paths;
        for (String path : paths = new String[]{"schemas", "resourceTypes", "traits", "securitySchemes"}) {
            this.removeSequenceForPath(node, path);
        }
        return node;
    }

    private void removeSequenceForPath(Node node, String path) {
        Node container = NodeSelector.selectFrom(path, node);
        if (container instanceof ArrayNode && !container.getChildren().isEmpty()) {
            Node uncle = container.getChildren().get(0);
            for (int i = 1; i < container.getChildren().size(); ++i) {
                Node sibling = container.getChildren().get(i);
                for (Node nephew : sibling.getChildren()) {
                    uncle.addChild(nephew);
                }
            }
            container.replaceTree(uncle);
        }
    }
}

