/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.phase;

import com.fasterxml.jackson.core.JsonParseException;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.impl.commons.nodes.ExternalSchemaTypeExpressionNode;
import org.raml.v2.internal.impl.commons.type.JsonSchemaExternalType;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.commons.type.XmlSchemaExternalType;
import org.raml.v2.internal.utils.SchemaGenerator;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.phase.Transformer;

public class SchemaValidationTransformer
implements Transformer {
    private ResourceLoader resourceLoader;

    public SchemaValidationTransformer(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public boolean matches(Node node) {
        return node instanceof ExternalSchemaTypeExpressionNode;
    }

    @Override
    public Node transform(Node node) {
        ExternalSchemaTypeExpressionNode schema = (ExternalSchemaTypeExpressionNode)node;
        try {
            ResolvedType resolvedType = schema.generateDefinition();
            if (resolvedType instanceof XmlSchemaExternalType) {
                SchemaGenerator.generateXmlSchema(this.resourceLoader, (XmlSchemaExternalType)resolvedType);
            } else if (resolvedType instanceof JsonSchemaExternalType) {
                SchemaGenerator.generateJsonSchema((JsonSchemaExternalType)resolvedType);
            }
        }
        catch (JsonParseException ex) {
            return ErrorNodeFactory.createInvalidSchemaNode(ex.getOriginalMessage());
        }
        catch (Exception e) {
            return ErrorNodeFactory.createInvalidSchemaNode(e.getMessage());
        }
        return node;
    }
}

