/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.rules;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.raml.v2.internal.impl.commons.nodes.TypeExpressionNode;
import org.raml.v2.internal.impl.commons.suggester.ReferenceSuggester;
import org.raml.v2.internal.impl.v10.type.TypeId;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.suggester.DefaultSuggestion;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class TypeExpressionReferenceRule
extends Rule {
    private ReferenceSuggester suggester = new ReferenceSuggester("types");

    @Override
    public boolean matches(@Nonnull Node node) {
        return node instanceof SimpleTypeNode;
    }

    @Override
    @Nonnull
    public Node apply(@Nonnull Node node) {
        if (node instanceof TypeExpressionNode) {
            return node;
        }
        return this.createNodeUsingFactory(node, ((StringNode)node).getLiteralValue());
    }

    @Override
    public String getDescription() {
        return "Type reference expression.";
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        TypeId[] values;
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>(this.suggester.getSuggestions(node));
        for (TypeId value : values = TypeId.values()) {
            suggestions.add(new DefaultSuggestion(value.getType(), "", StringUtils.capitalize(value.getType())));
        }
        return suggestions;
    }
}

