import fail from dw::Runtime
import validateAPIDoesNotContainSolaceUnsupportedScenarios from scripts::asyncapi::validations::SolaceValidations

/**
* Executes checks on the API Specification to stop scaffolding in case it contains unsupported scenarios
**/
fun validateAPICanBeScaffolded(api, publishOps, subscribeOps): Boolean =
    validateAPIHasChannelsWithOperations(publishOps, subscribeOps) and
    validateAPIDoesNotContainSolaceUnsupportedScenarios(api, publishOps, subscribeOps)

/**
* Checks if the API Specification contains Channels with operations
* If no Channel with operations is found, an error is thrown
*/
fun validateAPIHasChannelsWithOperations(publishOps, subscribeOps): Boolean =
    if (!isEmpty(publishOps) or !isEmpty(subscribeOps))
        true
    else
        fail("The AsyncAPI specification does not contain any Channels with Publish or Subscribe operations")
