/*
 * Decompiled with CFR 0.152.
 */
package org.mule.dx.contributions.scaffolding.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.mule.apikit.scaffolding.api.ScaffoldingDependency;
import org.mule.dx.contributions.exception.ComponentException;
import org.mule.dx.contributions.scaffolding.APIKitDependency;
import org.mule.dx.contributions.scaffolding.AsyncKitDependency;
import org.mule.dx.contributions.scaffolding.Dependency;
import org.mule.dx.contributions.scaffolding.GenericDependency;
import org.mule.dx.contributions.scaffolding.GraphQLDependency;
import org.mule.dx.contributions.scaffolding.HTTPDependency;
import org.mule.dx.contributions.scaffolding.MUnitRunnerDependency;
import org.mule.dx.contributions.scaffolding.MUnitToolsDependency;
import org.mule.dx.platform.api.dependency.DependencyModel;
import org.mule.dx.platform.api.dependency.DependencyModelManager;
import org.mule.dx.platform.api.graphql.GraphQlClient;
import org.mule.dx.platform.api.maven.MavenDependencyModel;
import org.mule.dx.platform.api.project.Project;
import org.mule.maven.pom.parser.api.model.BundleScope;

public class DependenciesHandler {
    public static final String FAILED_TO_ADD_MODULE_DEPENDENCIES = "Failed to add module dependencies";
    private final Map<String, List<Dependency>> dependencies;
    private final GraphQlClient graphQlClient;

    public DependenciesHandler(GraphQlClient graphQlClient) {
        ImmutableList restDependencies = ImmutableList.of((Object)new APIKitDependency(graphQlClient), (Object)new HTTPDependency(graphQlClient));
        ImmutableList asyncDependencies = ImmutableList.of((Object)new AsyncKitDependency(graphQlClient), (Object)new HTTPDependency(graphQlClient));
        ImmutableList graphqlDependencies = ImmutableList.of((Object)new GraphQLDependency(graphQlClient), (Object)new HTTPDependency(graphQlClient), (Object)new MUnitRunnerDependency(graphQlClient), (Object)new MUnitToolsDependency(graphQlClient));
        this.dependencies = ImmutableMap.of((Object)"raml", (Object)restDependencies, (Object)"oas", (Object)restDependencies, (Object)"evented-api", (Object)asyncDependencies, (Object)"graphql", (Object)graphqlDependencies, (Object)"light-graphql", (Object)graphqlDependencies, (Object)"graphql-apollo", (Object)graphqlDependencies, (Object)"light-graphql-apollo", (Object)graphqlDependencies);
        this.graphQlClient = graphQlClient;
    }

    public void addDependencies(Project project, String classifier, List<ScaffoldingDependency> scaffoldingDependencies) throws RuntimeException {
        List<Dependency> combinedList = this.getDependencies(classifier, scaffoldingDependencies);
        this.addDependencies(project, combinedList);
    }

    private List<Dependency> getDependencies(String classifier, List<ScaffoldingDependency> scaffoldingDependencies) {
        List<Dependency> moduleDependencies = this.dependencies.get(classifier);
        List connectorDependencies = scaffoldingDependencies.stream().map(scaffoldingDependency -> {
            String[] gavParts = scaffoldingDependency.gavCoordinate().split(":");
            String groupId = gavParts[0];
            String artifactId = gavParts[1];
            String version = gavParts[2];
            return new GenericDependency(this.graphQlClient, groupId, artifactId, version, scaffoldingDependency.classifier());
        }).collect(Collectors.toList());
        ArrayList<Dependency> combinedList = new ArrayList<Dependency>();
        combinedList.addAll(moduleDependencies);
        combinedList.addAll(connectorDependencies);
        return combinedList;
    }

    public void addDependencies(Project project, String classifier) throws RuntimeException {
        this.addDependencies(project, this.dependencies.get(classifier));
    }

    public MavenDependencyModel findDependency(DependencyModelManager<MavenDependencyModel> modelManager, String groupId, String artifactId, String version) {
        MavenDependencyModel dependencyModel = null;
        try {
            CompletableFuture mavenDependencyModelCompletableFuture = modelManager.loadModel();
            Collection models = ((MavenDependencyModel)mavenDependencyModelCompletableFuture.get()).getDependencies();
            List dependencyModels = models.stream().filter(m -> {
                MavenDependencyModel model = (MavenDependencyModel)m;
                return model.getGroupId().equals(groupId) && model.getArtifactId().equals(artifactId) && model.getVersion().equals(version);
            }).collect(Collectors.toList());
            dependencyModel = (MavenDependencyModel)dependencyModels.get(0);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw ComponentException.from(new RuntimeException("Failed to find dependency", e));
        }
        return dependencyModel;
    }

    private void addDependencies(Project project, List<Dependency> dependencies) throws RuntimeException {
        DependencyModelManager modelManager = (DependencyModelManager)project.getComponent(DependencyModelManager.class).orElseThrow(() -> new RuntimeException(FAILED_TO_ADD_MODULE_DEPENDENCIES));
        modelManager.mutator().ifPresent(mutator -> {
            dependencies.forEach(moduleDependency -> {
                boolean success = mutator.addDependency((DependencyModel)DependenciesHandler.toMavenDependencyModel(moduleDependency));
                if (!success) {
                    throw ComponentException.from(new RuntimeException(FAILED_TO_ADD_MODULE_DEPENDENCIES));
                }
            });
            mutator.persist();
        });
    }

    public static MavenDependencyModel toMavenDependencyModel(final Dependency moduleDependency) {
        return new MavenDependencyModel(){

            public String getGroupId() {
                return moduleDependency.groupId();
            }

            public String getArtifactId() {
                return moduleDependency.artifactId();
            }

            public String getBaseVersion() {
                return null;
            }

            public String getType() {
                return null;
            }

            public Optional<String> getClassifier() {
                return Optional.of(moduleDependency.classifier());
            }

            public BundleScope getScope() {
                return null;
            }

            public org.apache.maven.model.Dependency toMavenNativeModel() {
                org.apache.maven.model.Dependency dependency = new org.apache.maven.model.Dependency();
                dependency.setGroupId(moduleDependency.groupId());
                dependency.setArtifactId(moduleDependency.artifactId());
                dependency.setVersion(moduleDependency.version());
                dependency.setClassifier(moduleDependency.classifier());
                dependency.setScope(moduleDependency.scope());
                return dependency;
            }

            public String getId() {
                return null;
            }

            public Collection<DependencyModel> getDependencies() {
                return null;
            }

            public String getSystemID() {
                return null;
            }

            public String getVersion() {
                return moduleDependency.version();
            }

            public URI getLocation() {
                return null;
            }
        };
    }
}

