
package com.mule.modules.ftplite.processors;

import java.io.InputStream;
import java.util.List;
import javax.annotation.Generated;
import com.mule.modules.ftplite.FtpLiteConnector;
import com.mule.modules.ftplite.adapters.FtpLiteConnectorProcessAdapter;
import com.mule.modules.ftplite.process.ProcessAdapter;
import com.mule.modules.ftplite.process.ProcessCallback;
import com.mule.modules.ftplite.process.ProcessTemplate;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.common.DefaultResult;
import org.mule.common.Result;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.config.i18n.CoreMessages;


/**
 * GetFileContentMessageProcessor invokes the {@link com.mule.modules.ftplite.FtpLiteConnector#getFileContent(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)} method in {@link FtpLiteConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.0", date = "2014-01-31T11:09:53-06:00", comments = "Build 3.4.0.1555.8df15c1")
public class GetFileContentMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor, OperationMetaDataEnabled
{

    protected Object hostName;
    protected String _hostNameType;
    protected Object userName;
    protected String _userNameType;
    protected Object password;
    protected String _passwordType;
    protected Object port;
    protected String _portType;
    protected Object filePath;
    protected String _filePathType;
    protected Object passive;
    protected String _passiveType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets port
     * 
     * @param value Value to set
     */
    public void setPort(Object value) {
        this.port = value;
    }

    /**
     * Sets filePath
     * 
     * @param value Value to set
     */
    public void setFilePath(Object value) {
        this.filePath = value;
    }

    /**
     * Sets passive
     * 
     * @param value Value to set
     */
    public void setPassive(Object value) {
        this.passive = value;
    }

    /**
     * Sets userName
     * 
     * @param value Value to set
     */
    public void setUserName(Object value) {
        this.userName = value;
    }

    /**
     * Sets hostName
     * 
     * @param value Value to set
     */
    public void setHostName(Object value) {
        this.hostName = value;
    }

    /**
     * Sets password
     * 
     * @param value Value to set
     */
    public void setPassword(Object value) {
        this.password = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(FtpLiteConnectorProcessAdapter.class, true, event);
            final String _transformedHostName = ((String) evaluateAndTransform(getMuleContext(), event, GetFileContentMessageProcessor.class.getDeclaredField("_hostNameType").getGenericType(), null, hostName));
            final String _transformedUserName = ((String) evaluateAndTransform(getMuleContext(), event, GetFileContentMessageProcessor.class.getDeclaredField("_userNameType").getGenericType(), null, userName));
            final String _transformedPassword = ((String) evaluateAndTransform(getMuleContext(), event, GetFileContentMessageProcessor.class.getDeclaredField("_passwordType").getGenericType(), null, password));
            final String _transformedPort = ((String) evaluateAndTransform(getMuleContext(), event, GetFileContentMessageProcessor.class.getDeclaredField("_portType").getGenericType(), null, port));
            final String _transformedFilePath = ((String) evaluateAndTransform(getMuleContext(), event, GetFileContentMessageProcessor.class.getDeclaredField("_filePathType").getGenericType(), null, filePath));
            final String _transformedPassive = ((String) evaluateAndTransform(getMuleContext(), event, GetFileContentMessageProcessor.class.getDeclaredField("_passiveType").getGenericType(), null, passive));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((FtpLiteConnector) object).getFileContent(_transformedHostName, _transformedUserName, _transformedPassword, _transformedPort, _transformedFilePath, _transformedPassive);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("getFileContent"), event, e);
        }
    }

    @Override
    public Result<MetaData> getInputMetaData() {
        return new DefaultResult<MetaData>(null, (Result.Status.SUCCESS));
    }

    @Override
    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        return new DefaultResult<MetaData>(new DefaultMetaData(getPojoOrSimpleModel(InputStream.class)));
    }

    private MetaDataModel getPojoOrSimpleModel(Class clazz) {
        DataType dataType = DataTypeFactory.getInstance().getDataType(clazz);
        if (DataType.POJO.equals(dataType)) {
            return new DefaultPojoMetaDataModel(clazz);
        } else {
            return new DefaultSimpleMetaDataModel(dataType);
        }
    }

}
