/*
 * Decompiled with CFR 0.152.
 */
package com.mule.modules.ftplite;

import com.mule.modules.ftplite.FtpUtils;
import com.mule.modules.ftplite.exceptions.FtpLiteException;
import java.io.InputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

public class FtpLiteConnector {
    private static final String STANDARD_FTP_PORT = "21";
    private static final String DEFAULT_PASSIVE_MODE_ENABLED = "true";
    private static final String DEFAULT_FOLDER_PATH = "/";

    public FTPFile[] getFolder(String hostName, String userName, String password, String port, String path, String passive) throws FtpLiteException {
        FTPClient client = FtpUtils.createClient(hostName, port, passive, userName, password, path);
        FTPFile[] result = FtpUtils.getFiles(client);
        FtpUtils.releaseClient(client);
        return result;
    }

    public FTPFile getFile(String hostName, String userName, String password, String port, String filePath, String passive) throws FtpLiteException {
        int lastSlashIndex = filePath.lastIndexOf(DEFAULT_FOLDER_PATH);
        String path = filePath.substring(0, lastSlashIndex);
        String fileName = filePath.substring(lastSlashIndex + 1);
        if (path.equals("")) {
            path = DEFAULT_FOLDER_PATH;
        }
        FTPClient client = FtpUtils.createClient(hostName, port, passive, userName, password, path);
        FTPFile file = FtpUtils.getFile(client, fileName);
        FtpUtils.releaseClient(client);
        return file;
    }

    public InputStream getFileContent(String hostName, String userName, String password, String port, String filePath, String passive) throws FtpLiteException {
        FTPClient client = FtpUtils.createClient(hostName, port, passive, userName, password, null);
        InputStream result = FtpUtils.getFileContent(client, filePath);
        return result;
    }

    public FTPFile uploadStream(String hostName, String userName, String password, String port, String filePath, String fileName, InputStream content, String passive) throws FtpLiteException {
        FTPClient client = FtpUtils.createClient(hostName, port, passive, userName, password, filePath);
        FtpUtils.uploadStream(client, fileName, content);
        FTPFile file = FtpUtils.getFile(client, fileName);
        FtpUtils.releaseClient(client);
        return file;
    }
}

