
package com.mule.modules.ftplite.processors;

import java.util.List;
import javax.annotation.Generated;
import com.mule.modules.ftplite.FtpLiteConnector;
import com.mule.modules.ftplite.adapters.FtpLiteConnectorProcessAdapter;
import org.apache.commons.net.ftp.FTPFile;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.common.DefaultResult;
import org.mule.common.Result;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.security.oauth.callback.ProcessCallback;


/**
 * GetFileMessageProcessor invokes the {@link com.mule.modules.ftplite.FtpLiteConnector#getFile(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)} method in {@link FtpLiteConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.5.0-cascade", date = "2014-03-10T01:15:25-05:00", comments = "Build UNNAMED.1791.ad9d188")
public class GetFileMessageProcessor
    extends DevkitBasedMessageProcessor
    implements MessageProcessor, OperationMetaDataEnabled
{

    protected Object hostName;
    protected String _hostNameType;
    protected Object userName;
    protected String _userNameType;
    protected Object password;
    protected String _passwordType;
    protected Object port;
    protected String _portType;
    protected Object filePath;
    protected String _filePathType;
    protected Object passive;
    protected String _passiveType;

    public GetFileMessageProcessor(String operationName) {
        super(operationName);
    }

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    @Override
    public void start()
        throws MuleException
    {
        super.start();
    }

    @Override
    public void stop()
        throws MuleException
    {
        super.stop();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    /**
     * Sets port
     * 
     * @param value Value to set
     */
    public void setPort(Object value) {
        this.port = value;
    }

    /**
     * Sets filePath
     * 
     * @param value Value to set
     */
    public void setFilePath(Object value) {
        this.filePath = value;
    }

    /**
     * Sets passive
     * 
     * @param value Value to set
     */
    public void setPassive(Object value) {
        this.passive = value;
    }

    /**
     * Sets userName
     * 
     * @param value Value to set
     */
    public void setUserName(Object value) {
        this.userName = value;
    }

    /**
     * Sets hostName
     * 
     * @param value Value to set
     */
    public void setHostName(Object value) {
        this.hostName = value;
    }

    /**
     * Sets password
     * 
     * @param value Value to set
     */
    public void setPassword(Object value) {
        this.password = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws Exception
     */
    public MuleEvent doProcess(final MuleEvent event)
        throws Exception
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(FtpLiteConnectorProcessAdapter.class, true, event);
            final String _transformedHostName = ((String) evaluateAndTransform(getMuleContext(), event, GetFileMessageProcessor.class.getDeclaredField("_hostNameType").getGenericType(), null, hostName));
            final String _transformedUserName = ((String) evaluateAndTransform(getMuleContext(), event, GetFileMessageProcessor.class.getDeclaredField("_userNameType").getGenericType(), null, userName));
            final String _transformedPassword = ((String) evaluateAndTransform(getMuleContext(), event, GetFileMessageProcessor.class.getDeclaredField("_passwordType").getGenericType(), null, password));
            final String _transformedPort = ((String) evaluateAndTransform(getMuleContext(), event, GetFileMessageProcessor.class.getDeclaredField("_portType").getGenericType(), null, port));
            final String _transformedFilePath = ((String) evaluateAndTransform(getMuleContext(), event, GetFileMessageProcessor.class.getDeclaredField("_filePathType").getGenericType(), null, filePath));
            final String _transformedPassive = ((String) evaluateAndTransform(getMuleContext(), event, GetFileMessageProcessor.class.getDeclaredField("_passiveType").getGenericType(), null, passive));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class<? extends Exception>> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((FtpLiteConnector) object).getFile(_transformedHostName, _transformedUserName, _transformedPassword, _transformedPort, _transformedFilePath, _transformedPassive);
                }

            }
            , this, event);
            event.getMessage().setPayload(resultPayload);
            return event;
        } catch (Exception e) {
            throw e;
        }
    }

    @Override
    public Result<MetaData> getInputMetaData() {
        return new DefaultResult<MetaData>(null, (Result.Status.SUCCESS));
    }

    @Override
    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        return new DefaultResult<MetaData>(new DefaultMetaData(getPojoOrSimpleModel(FTPFile.class)));
    }

    private MetaDataModel getPojoOrSimpleModel(Class clazz) {
        DataType dataType = DataTypeFactory.getInstance().getDataType(clazz);
        if (DataType.POJO.equals(dataType)) {
            return new DefaultPojoMetaDataModel(clazz);
        } else {
            return new DefaultSimpleMetaDataModel(dataType);
        }
    }

}
