/*
 * Decompiled with CFR 0.152.
 */
package com.mule.modules.ftplite.io;

import com.mule.modules.ftplite.FtpUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.net.ftp.FTPClient;

public class FtpConnectionClosingInputStream
extends InputStream {
    private final FTPClient client;
    private final InputStream stream;

    public FtpConnectionClosingInputStream(FTPClient client, InputStream stream) {
        this.client = client;
        this.stream = stream;
    }

    @Override
    public int read() throws IOException {
        int result = this.stream.read();
        if (result == -1) {
            FtpUtils.releaseClient(this.client);
        }
        return result;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        int result = this.stream.read(bytes);
        if (result == -1) {
            FtpUtils.releaseClient(this.client);
        }
        return result;
    }

    @Override
    public int read(byte[] bytes, int i, int i2) throws IOException {
        int result = this.stream.read(bytes, i, i2);
        if (result == -1) {
            FtpUtils.releaseClient(this.client);
        }
        return result;
    }

    @Override
    public long skip(long l) throws IOException {
        return this.stream.skip(l);
    }

    @Override
    public int available() throws IOException {
        return this.stream.available();
    }

    @Override
    public void close() throws IOException {
        FtpUtils.releaseClient(this.client);
        this.stream.close();
    }

    @Override
    public synchronized void mark(int i) {
        this.stream.mark(i);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.stream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }

    public InputStream getStream() {
        return this.stream;
    }
}

