/*
 * Decompiled with CFR 0.152.
 */
package com.mule.modules.ftplite.config;

import com.mule.modules.ftplite.config.FtpLiteConnectorConfigDefinitionParser;
import com.mule.modules.ftplite.config.GetFileContentDefinitionParser;
import com.mule.modules.ftplite.config.GetFileDefinitionParser;
import com.mule.modules.ftplite.config.GetFolderDefinitionParser;
import com.mule.modules.ftplite.config.UploadStreamDefinitionParser;
import org.mule.config.MuleManifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class FtpliteNamespaceHandler
extends NamespaceHandlerSupport {
    private static Logger logger = LoggerFactory.getLogger(FtpliteNamespaceHandler.class);

    private void handleException(String beanName, String beanScope, NoClassDefFoundError noClassDefFoundError) {
        String muleVersion = "";
        try {
            muleVersion = MuleManifest.getProductVersion();
        }
        catch (Exception _x) {
            logger.error("Problem while reading mule version");
        }
        logger.error("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [ftplite] is not supported in mule " + muleVersion);
        throw new FatalBeanException("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [ftplite] is not supported in mule " + muleVersion, (Throwable)noClassDefFoundError);
    }

    public void init() {
        try {
            this.registerBeanDefinitionParser("config", (BeanDefinitionParser)new FtpLiteConnectorConfigDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("config", "@Config", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-folder", (BeanDefinitionParser)new GetFolderDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("get-folder", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-file", (BeanDefinitionParser)new GetFileDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("get-file", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-file-content", (BeanDefinitionParser)new GetFileContentDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("get-file-content", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("upload-stream", (BeanDefinitionParser)new UploadStreamDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("upload-stream", "@Processor", ex);
        }
    }
}

