/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.siebel.api;

import com.siebel.data.SiebelBusComp;
import com.siebel.data.SiebelBusObject;
import com.siebel.data.SiebelDataBean;
import com.siebel.data.SiebelException;
import com.siebel.data.SiebelPropertySet;
import com.siebel.data.SiebelService;
import org.mule.modules.siebel.api.SiebelDataBeanClient;

public class DefaultSiebelDataBeanClient
implements SiebelDataBeanClient {
    private SiebelDataBean siebelDataBean = new SiebelDataBean();

    @Override
    public void login(String siebelServer, String siebelPort, String siebelEnterpriseServer, String siebelMgr, String user, String password, String language, boolean rsaEnabled) throws SiebelException {
        String ecryptionType = "None";
        if (rsaEnabled) {
            ecryptionType = "rsa";
        }
        this.siebelDataBean.login(String.format("siebel.TCPIP.%s.None://%s:%s/%s/%s", ecryptionType, siebelServer, siebelPort, siebelEnterpriseServer, siebelMgr), user, password, language);
    }

    @Override
    public SiebelBusObject getBusinessObject(String type) throws SiebelException {
        return this.siebelDataBean.getBusObject(type);
    }

    @Override
    public SiebelBusComp getBusinessComponent(SiebelBusObject siebelBusObject, String type) throws SiebelException {
        return siebelBusObject.getBusComp(type);
    }

    @Override
    public void logoff() throws SiebelException {
        this.siebelDataBean.logoff();
    }

    @Override
    public SiebelDataBean getCurrentBean() {
        return this.siebelDataBean;
    }

    @Override
    public void updateBusinessComponent(SiebelBusComp component, SiebelPropertySet siebelPropertySet) throws SiebelException {
        component.setMultipleFieldValues(siebelPropertySet);
    }

    @Override
    public SiebelService getService(String serviceName) throws SiebelException {
        return this.siebelDataBean.getService(serviceName);
    }
}

