/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.siebel.util;

import com.siebel.data.SiebelBusComp;
import com.siebel.data.SiebelBusObject;
import com.siebel.data.SiebelException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.modules.siebel.api.SiebelDataBeanClient;
import org.mule.modules.siebel.util.SiebelConnectorUtils;

public class BusCompQuery {
    private SiebelDataBeanClient client;
    private String type;
    private List<String> fieldsToRetrieve;
    private Map<String, String> searchSpec;
    private String searchExpr;
    private String sortSpec;
    private Integer viewMode;
    private Boolean cursorMode;
    private Boolean ignoreMaxCursorSize;
    private String nrRecords;

    public BusCompQuery(SiebelDataBeanClient client, String type) {
        this.client = client;
        this.type = type;
        this.cursorMode = true;
        this.ignoreMaxCursorSize = true;
        this.viewMode = 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> executeQuery() throws SiebelException {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        SiebelBusObject businessObject = null;
        SiebelBusComp businessComponent = null;
        try {
            boolean bl;
            businessObject = this.client.getBusinessObject(SiebelConnectorUtils.extractBusinessObjectName(this.type));
            businessComponent = businessObject.getBusComp(SiebelConnectorUtils.extractBusinessComponentName(this.type));
            if (this.fieldsToRetrieve != null) {
                for (String string : this.fieldsToRetrieve) {
                    businessComponent.activateField(string);
                }
            }
            businessComponent.clearToQuery();
            if (this.searchSpec != null) {
                for (Map.Entry entry : this.searchSpec.entrySet()) {
                    businessComponent.setSearchSpec((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (this.searchExpr != null) {
                businessComponent.setSearchExpr(this.searchExpr);
            }
            if (this.sortSpec != null) {
                businessComponent.setSortSpec(this.sortSpec);
            }
            if (this.viewMode != null) {
                businessComponent.setViewMode(this.viewMode.intValue());
            }
            int nrRecords = -1;
            if (this.nrRecords != null && !this.nrRecords.equals("") && (nrRecords = Integer.parseInt(this.nrRecords)) < 0) {
                throw new IllegalArgumentException("Invalid number of records");
            }
            businessComponent.executeQuery2(this.cursorMode.booleanValue(), false);
            boolean bl2 = businessComponent.firstRecord();
            int contor = 0;
            while (bl) {
                if (nrRecords != -1) {
                    if (contor >= nrRecords) break;
                    ++contor;
                }
                HashMap<String, String> resultMap = new HashMap<String, String>();
                for (String field : this.fieldsToRetrieve) {
                    resultMap.put(field, businessComponent.getFieldValue(field));
                }
                bl = businessComponent.nextRecord();
                results.add(resultMap);
            }
        }
        finally {
            if (businessComponent != null) {
                businessComponent.release();
            }
            if (businessObject != null) {
                businessObject.release();
            }
        }
        return results;
    }

    public BusCompQuery setFieldsToRetrieve(List<String> fieldsToRetrieve) {
        this.fieldsToRetrieve = fieldsToRetrieve;
        return this;
    }

    public BusCompQuery setSearchSpecification(Map<String, String> searchSpec) {
        this.searchSpec = searchSpec;
        return this;
    }

    public BusCompQuery setSearchExpression(String searchExpr) {
        this.searchExpr = searchExpr;
        return this;
    }

    public BusCompQuery setSortSpecification(String sortSpec) {
        this.sortSpec = sortSpec;
        return this;
    }

    public BusCompQuery setViewMode(Integer viewMode) {
        this.viewMode = viewMode;
        return this;
    }

    public BusCompQuery setNrRecords(String nrRecords) {
        this.nrRecords = nrRecords;
        return this;
    }
}

