/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.siebel.util;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.common.metadata.AbstractStructuredMetaDataModel;
import org.mule.common.metadata.DefaultDefinedMapMetaDataModel;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataField;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.MetaDataProperties;
import org.mule.common.metadata.MetaDataPropertyScope;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.field.property.MetaDataFieldProperty;
import org.mule.common.metadata.field.property.ValidStringValuesFieldProperty;

public class MetadataSerializer {
    private final MetaData metadata;

    public MetadataSerializer(@NotNull MetaData metadata) {
        this.metadata = metadata;
    }

    public String toJson() {
        JsonTransformer transformer = new JsonTransformer();
        JSONObject json = transformer.generate(this.metadata);
        return json.toString(2);
    }

    private static class JsonTransformer {
        private JsonTransformer() {
        }

        public JSONObject generate(@NotNull MetaData metaData) {
            MetaDataPropertyScope[] values;
            JSONObject result = new JSONObject();
            for (MetaDataPropertyScope type : values = MetaDataPropertyScope.values()) {
                MetaDataProperties properties = metaData.getProperties(type);
                if (properties.getFields().isEmpty()) continue;
                result.put(type.name().toLowerCase(), (Object)this.generate(properties));
            }
            MetaDataModel payload = metaData.getPayload();
            result.put("payload-type", (Object)payload.getDataType().name().toLowerCase());
            result.put("payload", (Object)this.generate((AbstractStructuredMetaDataModel)payload));
            return result;
        }

        @NotNull
        public JSONObject generate(@NotNull MetaDataProperties properties) {
            JSONObject result = new JSONObject();
            Set fields = properties.getFields();
            for (MetaDataField field : fields) {
                result.put(field.getName(), (Collection)field.getProperties());
            }
            return result;
        }

        @NotNull
        public JSONObject generate(@NotNull AbstractStructuredMetaDataModel model) {
            JSONObject result = new JSONObject();
            List fields = model.getFields();
            for (MetaDataField field : fields) {
                String fieldDesc;
                String typeStr;
                String key = field.getName() != null ? field.getName() : "UNDEFINED";
                MetaDataModel dataModel = field.getMetaDataModel();
                if (dataModel instanceof DefaultListMetaDataModel) {
                    result.put(key, (Object)this.generate((DefaultListMetaDataModel)dataModel));
                    continue;
                }
                if (dataModel instanceof DefaultDefinedMapMetaDataModel) {
                    result.put(key, (Object)this.generate((AbstractStructuredMetaDataModel)((DefaultDefinedMapMetaDataModel)dataModel)));
                    continue;
                }
                DataType dataType = dataModel.getDataType();
                switch (dataType) {
                    case POJO: 
                    case ENUM: {
                        typeStr = dataType.getDefaultImplementationClass();
                        break;
                    }
                    default: {
                        typeStr = dataType.name().toLowerCase();
                    }
                }
                JSONObject props = this.generate(field.getProperties());
                if (props.keySet().isEmpty()) {
                    fieldDesc = typeStr;
                } else {
                    JSONObject value = new JSONObject();
                    value.put("type", (Object)typeStr);
                    value.put("props", (Object)props);
                    fieldDesc = value;
                }
                result.put(key, (Object)fieldDesc);
            }
            return result;
        }

        @NotNull
        public JSONArray generate(@NotNull DefaultListMetaDataModel model) {
            String typeStr;
            MetaDataModel listDataModel = model.getElementModel();
            JSONArray arrayResult = new JSONArray();
            DataType dataType = listDataModel.getDataType();
            switch (dataType) {
                case POJO: {
                    DefaultPojoMetaDataModel pojo = (DefaultPojoMetaDataModel)listDataModel;
                    JSONObject result = this.generate((AbstractStructuredMetaDataModel)pojo);
                    arrayResult.put((Object)result);
                    return arrayResult;
                }
                case MAP: {
                    DefaultDefinedMapMetaDataModel defaultMap = (DefaultDefinedMapMetaDataModel)listDataModel;
                    JSONObject result = this.generate((AbstractStructuredMetaDataModel)defaultMap);
                    arrayResult.put((Object)result);
                    return arrayResult;
                }
                case ENUM: {
                    typeStr = dataType.getDefaultImplementationClass();
                    break;
                }
                default: {
                    typeStr = dataType.name().toLowerCase();
                }
            }
            arrayResult.put((Object)typeStr);
            return arrayResult;
        }

        @NotNull
        private JSONObject generate(@NotNull List<MetaDataFieldProperty> properties) {
            JSONObject result = new JSONObject();
            for (MetaDataFieldProperty property : properties) {
                if (!(property instanceof ValidStringValuesFieldProperty)) continue;
                ValidStringValuesFieldProperty validProps = (ValidStringValuesFieldProperty)property;
                result.put("valid-values", (Collection)validProps.getValidStrings());
            }
            return result;
        }
    }
}

