/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.siebel.util;

import com.siebel.data.SiebelException;
import com.siebel.data.SiebelPropertySet;
import com.siebel.data.SiebelService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mule.common.metadata.DefaultDefinedMapMetaDataModel;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefaultMetaDataField;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaDataField;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.datatype.DataType;
import org.mule.modules.siebel.api.SiebelDataBeanClient;
import org.mule.modules.siebel.exception.SiebelAttachmentException;
import org.mule.modules.siebel.util.AttachmentStructureHelper;

public class SiebelConnectorUtils {
    private static int idNumber;

    private SiebelConnectorUtils() {
    }

    @NotNull
    public static Map<String, Object> propertySetToMap(@NotNull SiebelPropertySet propertySet) {
        return SiebelConnectorUtils.propertySetToMap(propertySet, null);
    }

    @NotNull
    public static Map<String, Object> propertySetToMap(@NotNull SiebelPropertySet propertySet, @Nullable AttachmentStructureHelper attach) {
        SiebelPropertySet child;
        Enumeration propertyNames = propertySet.getPropertyNames();
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            if (propertySet.getType().contains("Attachment") && attach != null && propertySet.getPropertyCount() > 0 && attach.isDataSenseStep()) {
                map.put("AttachmentContent", "");
            }
            if (attach != null && attach.isDataSenseStep() && propertySet.getPropertyCount() > 0 && !propertySet.getType().equals("SiebelMessage")) {
                map.put("operation", "");
            }
            if (propertySet.getType().contains("Attachment") && propertySet.getPropertyCount() > 0) {
                Object content;
                if (propertyName.contains(" Attachment Id") && attach != null && (content = attach.getContentMap().get(propertySet.getProperty(propertyName))) != null) {
                    map.put("AttachmentContent", content);
                }
                if (propertyName.equals("AttachmentContent")) continue;
            }
            map.put(propertyName, StringUtils.defaultString((String)propertySet.getProperty(propertyName)));
        }
        if (propertySet.getType().equals("SiebelMessage")) {
            for (int i = 0; i < propertySet.getChildCount(); ++i) {
                child = propertySet.getChild(i);
                if (!SiebelConnectorUtils.isListAttachment(child.getType())) continue;
                SiebelConnectorUtils.getListContentInfo(child, attach);
            }
        }
        for (int i = 0; i < propertySet.getChildCount(); ++i) {
            child = propertySet.getChild(i);
            if (SiebelConnectorUtils.isListAttachment(child.getType())) {
                SiebelConnectorUtils.getListContentInfo(child, attach);
                continue;
            }
            if (SiebelConnectorUtils.isListAttribute(child.getType())) {
                map.put(StringUtils.defaultIfEmpty((String)child.getType(), (String)("Child" + i)), SiebelConnectorUtils.propertySetToListOfMap(child, attach));
                continue;
            }
            Map<String, Object> propertyMap = SiebelConnectorUtils.propertySetToMap(child, attach);
            map.put(StringUtils.defaultIfEmpty((String)child.getType(), (String)("Child" + i)), propertyMap);
        }
        return map;
    }

    private static void getContentInfo(@NotNull SiebelPropertySet propertySet, @Nullable AttachmentStructureHelper attach) {
        if (propertySet.getType().equals("Document") && propertySet.getPropertyCount() > 0 && attach != null) {
            attach.getContentMap().put(propertySet.getProperty("ContentId"), propertySet.getByteValue());
        }
        for (int i = 0; i < propertySet.getChildCount(); ++i) {
            SiebelPropertySet child = propertySet.getChild(i);
            SiebelConnectorUtils.getContentInfo(child, attach);
        }
    }

    private static void getListContentInfo(@NotNull SiebelPropertySet propertySet, @Nullable AttachmentStructureHelper attach) {
        for (int i = 0; i < propertySet.getChildCount(); ++i) {
            SiebelPropertySet child = propertySet.getChild(i);
            SiebelConnectorUtils.getContentInfo(child, attach);
        }
    }

    private static List<Map<String, Object>> propertySetToListOfMap(SiebelPropertySet propertySet, AttachmentStructureHelper attach) {
        ArrayList<Map<String, Object>> listOfMaps = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < propertySet.getChildCount(); ++i) {
            SiebelPropertySet child = propertySet.getChild(i);
            HashMap<String, Map<String, Object>> childMap = new HashMap<String, Map<String, Object>>();
            childMap.put(child.getType(), SiebelConnectorUtils.propertySetToMap(child, attach));
            listOfMaps.add(childMap);
        }
        return listOfMaps;
    }

    @NotNull
    public static SiebelPropertySet mapToPropertySet(@NotNull Map<String, Object> map) {
        return SiebelConnectorUtils.mapToPropertySet(map, null, null);
    }

    @NotNull
    public static SiebelPropertySet mapToPropertySet(@NotNull Map<String, Object> map, @Nullable String parentType, @Nullable AttachmentStructureHelper attach) {
        SiebelPropertySet propertySet = new SiebelPropertySet();
        if (parentType != null) {
            propertySet.setType(parentType);
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                SiebelPropertySet child = SiebelConnectorUtils.mapToPropertySet((Map)entry.getValue(), null, attach);
                if (child.getPropertyCount() == 0 && child.getChildCount() == 0) continue;
                child.setType(entry.getKey());
                propertySet.addChild(child);
                continue;
            }
            if (entry.getValue() instanceof List) {
                SiebelPropertySet child = new SiebelPropertySet();
                child.setType(entry.getKey());
                for (Map childMap : (List)entry.getValue()) {
                    SiebelPropertySet convertedPropertySet = SiebelConnectorUtils.mapToPropertySet(childMap, null, attach);
                    if (convertedPropertySet.getChildCount() > 0) {
                        child.addChild(convertedPropertySet.getChild(0));
                        continue;
                    }
                    child.addChild(convertedPropertySet);
                }
                propertySet.addChild(child);
                continue;
            }
            if (entry.getKey().contains("FileName") && map.get("AttachmentContent") != null && attach != null) {
                int attachmentIndex = entry.getKey().indexOf("FileName");
                StringBuilder attachmentName = new StringBuilder(entry.getKey().substring(0, attachmentIndex));
                attachmentName.append(" Attachment Id");
                String id = SiebelConnectorUtils.generateId();
                attach.getContentMap().put(id, map.get("AttachmentContent"));
                propertySet.setProperty(attachmentName.toString(), id);
                propertySet.setProperty(entry.getKey(), (String)entry.getValue());
                continue;
            }
            if (entry.getKey().equals("AttachmentContent") || !StringUtils.isNotBlank((String)((String)entry.getValue()))) continue;
            propertySet.setProperty(entry.getKey(), (String)entry.getValue());
        }
        return propertySet;
    }

    @NotNull
    public static SiebelPropertySet attachDocumentToPropertySet(@NotNull SiebelPropertySet message, @Nullable AttachmentStructureHelper attach) throws SiebelAttachmentException {
        SiebelPropertySet intObj = message.getChild(0);
        SiebelPropertySet attachBranch = new SiebelPropertySet();
        attachBranch.setType("Attachments");
        if (attach != null) {
            for (Map.Entry<String, Object> entry : attach.getContentMap().entrySet()) {
                SiebelPropertySet parentMap = new SiebelPropertySet();
                SiebelPropertySet docMap = new SiebelPropertySet();
                docMap.setType("Document");
                docMap.setProperty("ContentId", entry.getKey());
                if (entry.getValue() instanceof byte[]) {
                    docMap.setByteValue((byte[])entry.getValue());
                } else if (entry.getValue() instanceof InputStream) {
                    InputStream content = (InputStream)entry.getValue();
                    try {
                        byte[] contentBytes = IOUtils.toByteArray((InputStream)content);
                        docMap.setByteValue(contentBytes);
                        content.close();
                    }
                    catch (IOException e) {
                        throw new SiebelAttachmentException(e, "Error while reading the stream");
                    }
                } else {
                    throw new SiebelAttachmentException(null, "Incorrect type of attachment. The supported types are InputStream and byte array.");
                }
                parentMap.addChild(docMap);
                attachBranch.addChild(docMap);
            }
        }
        intObj.addChild(attachBranch);
        return message;
    }

    @NotNull
    public static SiebelPropertySet mapToPropertySet(@NotNull Map<String, Object> map, @Nullable AttachmentStructureHelper attach) throws SiebelException {
        return SiebelConnectorUtils.mapToPropertySet(map, null, attach);
    }

    @NotNull
    public static Map<String, Object> mergePropertyMaps(@NotNull Map<String, Object> sourceMap, @NotNull Map<String, Object> valuesToMerge) {
        for (Map.Entry<String, Object> entry : valuesToMerge.entrySet()) {
            String keyToMerge = entry.getKey();
            Object valueToMerge = entry.getValue();
            Object sourceValue = sourceMap.get(keyToMerge);
            if (valueToMerge instanceof Map && sourceValue instanceof Map) {
                Map originalChild = (Map)sourceValue;
                Map newChild = (Map)valueToMerge;
                sourceMap.put(keyToMerge, SiebelConnectorUtils.mergePropertyMaps(originalChild, newChild));
                continue;
            }
            sourceMap.put(keyToMerge, valueToMerge);
        }
        return sourceMap;
    }

    @NotNull
    public static SiebelPropertySet createEmptyPropertySetFromIntegrationObject(@NotNull SiebelDataBeanClient client, @NotNull String integrationObjectName) throws SiebelException {
        SiebelPropertySet input = new SiebelPropertySet();
        SiebelPropertySet output = new SiebelPropertySet();
        input.setProperty("Hierarchy Name", integrationObjectName);
        SiebelService service = client.getService("PRM ANI Utility Service");
        service.invokeMethod("CreateEmptyPropSet", input, output);
        service.release();
        return output;
    }

    public static List<MetaDataField> getMetaDataFieldFromMap(Map<String, Object> map) {
        ArrayList<MetaDataField> metaDataFields = new ArrayList<MetaDataField>(map.size());
        DefaultMetaDataField field = null;
        for (Map.Entry<String, Object> mapEntry : map.entrySet()) {
            DefaultMetaDataField fieldModel;
            List<MetaDataField> fields;
            String fieldName = mapEntry.getKey();
            if (mapEntry.getValue() instanceof Map) {
                fields = SiebelConnectorUtils.getMetaDataFieldFromMap((Map)mapEntry.getValue());
                if (!mapEntry.getKey().equals("SiebelMessage")) {
                    field = new DefaultMetaDataField("searchspec", (MetaDataModel)new DefaultSimpleMetaDataModel(DataType.STRING));
                    fields.add((MetaDataField)field);
                }
                fieldModel = new DefaultMetaDataField(fieldName, (MetaDataModel)new DefaultDefinedMapMetaDataModel(fields, fieldName));
                metaDataFields.add((MetaDataField)fieldModel);
                continue;
            }
            if (mapEntry.getValue() instanceof List) {
                fields = SiebelConnectorUtils.getMetaDataFieldFromMap((Map)((List)mapEntry.getValue()).get(0));
                fieldModel = new DefaultMetaDataField(fieldName, (MetaDataModel)new DefaultListMetaDataModel((MetaDataModel)new DefaultDefinedMapMetaDataModel(fields, fieldName)));
                metaDataFields.add((MetaDataField)fieldModel);
                continue;
            }
            field = null;
            field = fieldName.equals("AttachmentContent") ? new DefaultMetaDataField(fieldName, (MetaDataModel)new DefaultPojoMetaDataModel(Object.class)) : new DefaultMetaDataField(fieldName, (MetaDataModel)new DefaultSimpleMetaDataModel(DataType.STRING));
            metaDataFields.add((MetaDataField)field);
        }
        return metaDataFields;
    }

    public static String getBusinessComponentNameFromMetadata(MetaDataKey key) {
        return StringUtils.substringAfter((String)key.getId(), (String)".");
    }

    public static String extractBusinessServiceMethodName(String fullName) {
        return StringUtils.substringAfter((String)fullName, (String)".");
    }

    public static String extractBusinessServiceName(String fullName) {
        return StringUtils.substringBefore((String)fullName, (String)".");
    }

    public static String extractBusinessObjectName(String fullName) {
        return StringUtils.substringBefore((String)fullName, (String)".");
    }

    public static String extractBusinessComponentName(String fullName) {
        return StringUtils.substringAfter((String)fullName, (String)".");
    }

    public static boolean isListAttribute(String attributeName) {
        return attributeName.startsWith("ListOf");
    }

    public static boolean isListAttachment(String attributeName) {
        return attributeName.startsWith("Attachments");
    }

    @NotNull
    private static synchronized String generateId() {
        String id = "1-BT" + idNumber;
        ++idNumber;
        return id;
    }
}

