/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.siebel.api;

import com.siebel.data.SiebelBusComp;
import com.siebel.data.SiebelBusObject;
import com.siebel.data.SiebelDataBean;
import com.siebel.data.SiebelException;
import com.siebel.data.SiebelPropertySet;
import com.siebel.data.SiebelService;
import com.siebel.om.conmgr.ConMgrException;
import com.siebel.om.conmgr.VirtualServer;
import org.mule.modules.siebel.api.SiebelConnectParams;
import org.mule.modules.siebel.api.SiebelDataBeanClient;

public class DefaultSiebelDataBeanClient
implements SiebelDataBeanClient {
    public static final String VIRTUAL_SERVER_NAME = "VirtualServer1";
    private static final String CONNECT_STRING_SINGLE_HOST_FORMAT = "siebel.TCPIP.%s.None://%s:%s/%s/%s";
    private static final String CONNECT_STRING_MULTIPLE_HOSTS_FORMAT = "siebel.TCPIP.%s.None://%s/%s/%s";
    private SiebelDataBean siebelDataBean = new SiebelDataBean();

    @Override
    public void login(SiebelConnectParams siebelConnectParams, boolean rsaEnabled) throws SiebelException, ConMgrException {
        String encryptionType = "None";
        if (rsaEnabled) {
            encryptionType = "rsa";
        }
        String connectString = this.createConnectString(siebelConnectParams, encryptionType);
        this.siebelDataBean.login(connectString, siebelConnectParams.getUser(), siebelConnectParams.getPassword(), siebelConnectParams.getLanguage());
    }

    private String createConnectString(SiebelConnectParams siebelConnectParams, String encryptionType) throws ConMgrException {
        return this.shouldConnectToSingleHost(siebelConnectParams) ? this.createSingleHostConnectString(siebelConnectParams, encryptionType) : this.createVirtualHostConnectString(siebelConnectParams, encryptionType);
    }

    private boolean shouldConnectToSingleHost(SiebelConnectParams siebelConnectParams) {
        return siebelConnectParams.getSiebelServer() == null || siebelConnectParams.getSiebelServer().isEmpty() || !siebelConnectParams.getSiebelServer().contains(VIRTUAL_SERVER_NAME);
    }

    private String createSingleHostConnectString(SiebelConnectParams siebelConnectParams, String encryptionType) {
        return String.format(CONNECT_STRING_SINGLE_HOST_FORMAT, encryptionType, siebelConnectParams.getSiebelServer(), siebelConnectParams.getSiebelPort(), siebelConnectParams.getSiebelEnterpriseServer(), siebelConnectParams.getSiebelMgr());
    }

    private String createVirtualHostConnectString(SiebelConnectParams siebelConnectParams, String encryptionType) throws ConMgrException {
        VirtualServer.initializeVirtualServers((String)siebelConnectParams.getSiebelServer());
        return String.format(CONNECT_STRING_MULTIPLE_HOSTS_FORMAT, encryptionType, VIRTUAL_SERVER_NAME, siebelConnectParams.getSiebelEnterpriseServer(), siebelConnectParams.getSiebelMgr());
    }

    @Override
    public SiebelBusObject getBusinessObject(String type) throws SiebelException {
        return this.siebelDataBean.getBusObject(type);
    }

    @Override
    public SiebelBusComp getBusinessComponent(SiebelBusObject siebelBusObject, String type) throws SiebelException {
        return siebelBusObject.getBusComp(type);
    }

    @Override
    public void logoff() throws SiebelException {
        this.siebelDataBean.logoff();
    }

    @Override
    public SiebelDataBean getCurrentBean() {
        return this.siebelDataBean;
    }

    @Override
    public void updateBusinessComponent(SiebelBusComp component, SiebelPropertySet siebelPropertySet) throws SiebelException {
        component.setMultipleFieldValues(siebelPropertySet);
    }

    @Override
    public SiebelService getService(String serviceName) throws SiebelException {
        return this.siebelDataBean.getService(serviceName);
    }
}

