/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.wsdl;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.staxutils.StaxSource;
import org.mule.modules.wsdl.header.SOAPHeaderBuilder;
import org.mule.modules.wsdl.header.SOAPHeaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WSDLInvocation {
    private static final Logger logger = LoggerFactory.getLogger(WSDLInvocation.class);
    private static final Object NULL_PAYLOAD_XML_TAG = "<NullPayload/>";
    private static final String CONNECTION_TIMEOUT = "com.sun.xml.internal.ws.connect.timeout";
    private static final String READ_TIMEOUT = "com.sun.xml.internal.ws.request.timeout";
    private XMLInputFactory inputFactory;
    private String basePath;
    private SOAPHeaderBuilder soapHeaderBuilder;
    private String headerQNamePrefix;
    private Map<String, String> headerParams;
    private String wsdlNamespace;
    private String serviceName;
    private String portName;
    private Integer connectionTimeout;
    private Integer readTimeout;

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getWsdlNamespace() {
        return this.wsdlNamespace;
    }

    public void setWsdlNamespace(String wsdlNamespace) {
        this.wsdlNamespace = wsdlNamespace;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public XMLStreamReader invoke(String type, XMLStreamReader input) {
        XMLStreamReader result = null;
        String[] wsdlAndOperation = type.split("#");
        String wsdlName = wsdlAndOperation[0];
        String operationName = wsdlAndOperation[1];
        String headerPrefix = "headerPrefix";
        String bodyPrefix = "bodyPrefix";
        String methodName = operationName;
        try {
            Dispatch dispatch;
            QName serviceQName = new QName(this.wsdlNamespace, this.serviceName);
            QName portQName = new QName(this.wsdlNamespace, this.portName);
            String endpointAddress = this.basePath + wsdlName;
            Service service = Service.create((QName)serviceQName);
            service.addPort(portQName, "http://schemas.xmlsoap.org/wsdl/soap/http", endpointAddress);
            Dispatch bp = dispatch = service.createDispatch(portQName, SOAPMessage.class, Service.Mode.MESSAGE);
            Map rc = bp.getRequestContext();
            rc.put("javax.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
            rc.put("javax.xml.ws.soap.http.soapaction.uri", methodName);
            rc.put(CONNECTION_TIMEOUT, this.getConnectionTimeout());
            rc.put(READ_TIMEOUT, this.getReadTimeout());
            MessageFactory factory = ((SOAPBinding)bp.getBinding()).getMessageFactory();
            SOAPMessage request = factory.createMessage();
            SOAPPart part = request.getSOAPPart();
            SOAPEnvelope env = part.getEnvelope();
            env.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
            env.addNamespaceDeclaration(bodyPrefix, this.wsdlNamespace + methodName + "/");
            env.addNamespaceDeclaration(headerPrefix, this.wsdlNamespace);
            SOAPHeader header = env.getHeader();
            if (this.soapHeaderBuilder != null) {
                this.soapHeaderBuilder.build(header, this);
            }
            if (this.headerParams != null) {
                for (String key : this.headerParams.keySet()) {
                    header.addChildElement(new QName(this.wsdlNamespace, key, this.headerQNamePrefix)).addTextNode(this.headerParams.get(key));
                }
            }
            SOAPBody body = env.getBody();
            String xml = this.getOuterXml(input);
            if (xml.trim().equals(NULL_PAYLOAD_XML_TAG)) {
                xml = StringUtils.join((Object[])new Object[]{"<ns0:", operationName, " xmlns:ns0=\"", this.wsdlNamespace.substring(0, this.wsdlNamespace.length() - 1), "\"/>"});
            }
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.parse(new InputSource(new StringReader(xml)));
            body.addDocument(document);
            request.saveChanges();
            SOAPMessage reply = (SOAPMessage)dispatch.invoke((Object)request);
            if (reply == null) {
                return null;
            }
            SOAPBodyElement sourceContent = (SOAPBodyElement)reply.getSOAPBody().getChildElements().next();
            NamedNodeMap envelopeAttributes = reply.getSOAPPart().getChildNodes().item(0).getAttributes();
            for (int i = 0; i < envelopeAttributes.getLength(); ++i) {
                sourceContent.addAttribute(env.createName(envelopeAttributes.item(i).getNodeName()), envelopeAttributes.item(i).getNodeValue());
            }
            DOMSource source = new DOMSource((Node)sourceContent);
            XMLInputFactory iFactory = this.getInputFactory();
            XMLStreamReader reader = iFactory.createXMLStreamReader(source);
            result = new StAXSource(reader).getXMLStreamReader();
        }
        catch (SOAPException e) {
            this.logExceptionDuringInvocation(e);
        }
        catch (TransformerConfigurationException e) {
            this.logExceptionDuringInvocation(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            this.logExceptionDuringInvocation(e);
        }
        catch (TransformerException e) {
            this.logExceptionDuringInvocation(e);
        }
        catch (ParserConfigurationException e) {
            this.logExceptionDuringInvocation(e);
        }
        catch (SAXException e) {
            this.logExceptionDuringInvocation(e);
        }
        catch (IOException e) {
            this.logExceptionDuringInvocation(e);
        }
        catch (XMLStreamException e) {
            this.logExceptionDuringInvocation(e);
        }
        catch (SOAPHeaderException e) {
            this.logExceptionDuringInvocation(e);
        }
        return result;
    }

    private void logExceptionDuringInvocation(Throwable e) {
        logger.warn("Error during web service invocation", e);
    }

    private XMLInputFactory getInputFactory() {
        if (this.inputFactory == null) {
            this.inputFactory = this.createInputFactory();
        }
        return this.inputFactory;
    }

    private XMLInputFactory createInputFactory() {
        return XMLInputFactory.newInstance();
    }

    private String getOuterXml(XMLStreamReader xmlr) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        StringWriter stringWriter = new StringWriter();
        transformer.transform((Source)new StaxSource(xmlr), new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    public String getHeaderQNamePrefix() {
        return this.headerQNamePrefix;
    }

    public void setHeaderQNamePrefix(String headerQNamePrefix) {
        this.headerQNamePrefix = headerQNamePrefix;
    }

    public void setHeaderParams(Map<String, String> headerParams) {
        this.headerParams = headerParams;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setSoapHeaderBuilder(SOAPHeaderBuilder soapHeaderBuilder) {
        this.soapHeaderBuilder = soapHeaderBuilder;
    }
}

