/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.wsdl.header;

import javax.xml.soap.SOAPHeader;

/**
 * Exception to be thrown when problems arise creating while {@link SOAPHeader SOAP Headers}.
 *
 * @author martin.paoloni@mulesoft.com
 */
public class SOAPHeaderException extends Exception {

    /** Serial Version ID. */
    private static final long serialVersionUID = 7322894771315550250L;

    /**
     * Constructs a {@link SOAPHeaderException}.
     */
    public SOAPHeaderException() {
        super();
    }

    /**
     * Constructs a {@link SOAPHeaderException}.
     *
     * @param message
     *            the detail message (which is saved for later retrieval by the getMessage() method).
     * @param cause
     *            the cause (which is saved for later retrieval by the getCause() method). (A null value is permitted, and indicates that the cause is nonexistent or unknown.)
     */
    public SOAPHeaderException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a {@link SOAPHeaderException}.
     *
     * @param message
     *            the detail message (which is saved for later retrieval by the getMessage() method).
     */
    public SOAPHeaderException(String message) {
        super(message);
    }

    /**
     * Constructs a {@link SOAPHeaderException}.
     *
     * @param cause
     *            the cause (which is saved for later retrieval by the getCause() method). (A null value is permitted, and indicates that the cause is nonexistent or unknown.)
     */
    public SOAPHeaderException(Throwable cause) {
        super(cause);
    }
}
