package org.mule.modules.wsdl.header;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;

import org.apache.commons.lang.Validate;
import org.mule.modules.wsdl.WSDLInvocation;

/**
 * WSSE Security header builder for the {@link WSDLInvocation WSDL Invoker}.
 *
 * @author martin.paoloni@mulesoft.com
 */
public class WsseSecurityHeaderBuilder implements SOAPHeaderBuilder {

    /** The user name. */
    private String username;
    /** The password. */
    private String password;

    /**
     * Constructs a {@link WsseSecurityHeaderBuilder WSSE Security Header Builder} to use with the {@link WSDLInvocation WSDL Invoker}.
     *
     * @param username
     *            The user name. Cannot be null or empty.
     * @param password
     *            The password. Cannot be null or empty.
     */
    public WsseSecurityHeaderBuilder(final String username, final String password) {
        Validate.notNull(username, "The user name cannot be null or empty.");
        Validate.notNull(password, "The password cannot be null or empty.");
        this.username = username;
        this.password = password;
    }

    /**
     * Gets the user name.
     *
     * @return the user name.
     */
    public String getUsername() {
        return username;
    }

    /**
     * Gets the password.
     *
     * @return the password.
     */
    public String getPassword() {
        return password;
    }

    @Override
    public void build(final SOAPHeader header, WSDLInvocation wsdlInvocation) throws SOAPHeaderException {
        try {
            SOAPElement security = header.addChildElement("Security", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");

            SOAPElement usernameToken = security.addChildElement("UsernameToken", "wsse");
            usernameToken.addAttribute(new QName("xmlns:wsu"), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");

            SOAPElement usernameElement = usernameToken.addChildElement("Username", "wsse");
            usernameElement.addTextNode(username);

            SOAPElement passwordElement = usernameToken.addChildElement("Password", "wsse");
            passwordElement.addTextNode(password);

        } catch (SOAPException e) {
            throw new SOAPHeaderException(e);
        }
    }
}
