/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.wsdl.datasense;

import org.mule.common.metadata.MetaData;

/**
 * Exception to be thrown when problems arise processing {@link MetaData} in WSDL files.
 *
 * @author martin.paoloni@mulesoft.com
 */
public class WsdlDatasenseException extends Exception {

    /**
     * Serial Version ID.
     */
    private static final long serialVersionUID = -7957692743137541842L;

    /**
     * Constructs a {@link WsdlDatasenseException}.
     */
    public WsdlDatasenseException() {
        super();
    }

    /**
     * Constructs a {@link WsdlDatasenseException}.
     *
     * @param message the detail message (which is saved for later retrieval by the getMessage() method).
     * @param cause   the cause (which is saved for later retrieval by the getCause() method). (A null value is permitted, and indicates that the cause is nonexistent or unknown.)
     */
    public WsdlDatasenseException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a {@link WsdlDatasenseException}.
     *
     * @param message the detail message (which is saved for later retrieval by the getMessage() method).
     */
    public WsdlDatasenseException(String message) {
        super(message);
    }

    /**
     * Constructs a {@link WsdlDatasenseException}.
     *
     * @param cause the cause (which is saved for later retrieval by the getCause() method). (A null value is permitted, and indicates that the cause is nonexistent or unknown.)
     */
    public WsdlDatasenseException(Throwable cause) {
        super(cause);
    }
}
