package org.mule.modules.wsdl.runtime;

import org.apache.cxf.staxutils.StaxSource;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.*;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

class XmlConverterUtils {

    /**
     * The instance of {@link XMLInputFactory}.
     */
    private static XMLInputFactory inputFactory = XMLInputFactory.newInstance();

    private XmlConverterUtils()

    {
    }

    /**
     * Reads a {@link XMLStreamReader} and converts it to {@link String}.
     *
     * @param xmlr A {@link XMLStreamReader}.
     * @return The XML, as a {@link String}.
     * @throws TransformerException If there is a problem converting the XML to {@link String}.
     */
    @NotNull
    static String xmlStreamToStr(@NotNull final XMLStreamReader xmlr) throws TransformerException {

        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
        transformer.setOutputProperty(OutputKeys.INDENT, "yes");

        StringWriter stringWriter = new StringWriter();
        final StaxSource xmlSource = new StaxSource(xmlr);
        transformer.transform(xmlSource, new StreamResult(stringWriter));

        return stringWriter.toString();
    }

    /**
     * Extracted from http://www.coderanch.com/t/484306/Web-Services/java/Attaching-XML-Message-SoapBody
     *
     * @param payloadStr
     * @return
     * @throws ParserConfigurationException
     * @throws SAXException
     * @throws IOException
     */

    @NotNull
    static Document convertStringToDocument(@NotNull final String xmlStr) throws ParserConfigurationException, SAXException, IOException {

        final DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);

        final DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        final InputSource is = new InputSource(new StringReader(xmlStr));
        return docBuilder.parse(is);
    }

    @NotNull
    static XMLStreamReader soapResponseToXmlStream(@NotNull final SOAPMessage soapResponse, @NotNull final SOAPBodyElement sourceContent, @NotNull final SOAPEnvelope soapEnvelope)
            throws SOAPException, XMLStreamException {

        final SOAPPart responsePart = soapResponse.getSOAPPart();
        final NodeList childNodes = responsePart.getChildNodes();

        final NamedNodeMap envelopeAttributes = childNodes.item(0).getAttributes();
        for (int i = 0; i < envelopeAttributes.getLength(); i++) {
            final org.w3c.dom.Node node = envelopeAttributes.item(i);
            final String nodeName = node.getNodeName();
            final Name name = soapEnvelope.createName(nodeName);
            sourceContent.addAttribute(name, node.getNodeValue());
        }

        // Build XML InputStream
        final DOMSource source = new DOMSource(sourceContent);
        final XMLStreamReader reader = inputFactory.createXMLStreamReader(source);
        final StAXSource stAXSource = new StAXSource(reader);
        return stAXSource.getXMLStreamReader();
    }
}
