package org.mule.modules.wsdl.runtime;

import org.jetbrains.annotations.NotNull;

/**
 * Models a SOAP service endpoint
 */
public class ServiceDefinition {

    /**
     * The namespace of the WSDL file.
     */
    private final String namespace;

    private final String serviceName;

    private final String portName;

    /**
     * The base path for the WSDL. Appending (WSDLname)/?wsdl to this should return the WSDL.
     */
    private final String baseEndpoint;

    /**
     * The QName prefix to be used when creating the header.
     */

    private final String headerPrefix;

    private ServiceDefinition(@NotNull final String namespace, @NotNull final String serviceName, @NotNull final String portName, @NotNull final String baseEndpoint,
            @NotNull final String headerPrefix) {
        this.namespace = namespace;
        this.serviceName = serviceName;
        this.portName = portName;
        this.baseEndpoint = baseEndpoint;
        this.headerPrefix = headerPrefix;
    }

    public static ServiceDefinition create(@NotNull final String namespace, @NotNull final String serviceName, @NotNull final String portName, @NotNull final String baseEndpoint,
            @NotNull final String headerPrefix) {
        return new ServiceDefinition(namespace, serviceName, portName, baseEndpoint, headerPrefix);
    }

    @NotNull
    public String getNamespace() {
        return namespace;
    }

    @NotNull
    public String getServiceName() {
        return serviceName;
    }

    @NotNull
    public String getPortName() {
        return portName;
    }

    @NotNull
    public String getBaseEndpoint() {
        return baseEndpoint;
    }

    @NotNull
    public String getHeaderPrefix() {
        return headerPrefix;
    }

    @Override
    public String toString() {
        return "ServiceDefinition{" +
                "namespace='" + namespace + '\'' +
                ", serviceName='" + serviceName + '\'' +
                ", portName='" + portName + '\'' +
                ", baseEndpoint='" + baseEndpoint + '\'' +
                ", headerPrefix='" + headerPrefix + '\'' +
                '}';
    }

}
