/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.wsdl.runtime;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.cxf.staxutils.StaxSource;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class XmlConverterUtils {
    private static XMLInputFactory inputFactory = XMLInputFactory.newInstance();

    private XmlConverterUtils() {
    }

    @NotNull
    static String xmlStreamToStr(@NotNull XMLStreamReader xmlr) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        StringWriter stringWriter = new StringWriter();
        StaxSource xmlSource = new StaxSource(xmlr);
        transformer.transform((Source)xmlSource, new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    @NotNull
    static Document convertStringToDocument(@NotNull String xmlStr) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(xmlStr));
        return docBuilder.parse(is);
    }

    @NotNull
    static XMLStreamReader soapResponseToXmlStream(@NotNull SOAPMessage soapResponse, @NotNull SOAPBodyElement sourceContent, @NotNull SOAPEnvelope soapEnvelope) throws SOAPException, XMLStreamException {
        SOAPPart responsePart = soapResponse.getSOAPPart();
        NodeList childNodes = responsePart.getChildNodes();
        NamedNodeMap envelopeAttributes = childNodes.item(0).getAttributes();
        for (int i = 0; i < envelopeAttributes.getLength(); ++i) {
            Node node = envelopeAttributes.item(i);
            String nodeName = node.getNodeName();
            Name name = soapEnvelope.createName(nodeName);
            sourceContent.addAttribute(name, node.getNodeValue());
        }
        DOMSource source = new DOMSource((Node)sourceContent);
        XMLStreamReader reader = inputFactory.createXMLStreamReader(source);
        StAXSource stAXSource = new StAXSource(reader);
        return stAXSource.getXMLStreamReader();
    }
}

