package org.mule.modules.wsdl.runtime;

import java.io.StringReader;

import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXSource;

import org.jetbrains.annotations.NotNull;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

class XmlConverterUtils {

    /**
     * The instance of {@link XMLInputFactory}.
     */
    private static XMLInputFactory inputFactory = XMLInputFactory.newInstance();

    private XmlConverterUtils() {
    }

    @NotNull
    static XMLStreamReader soapResponseToXmlStream(@NotNull final SOAPMessage soapResponse, @NotNull final SOAPBodyElement sourceContent, @NotNull final SOAPEnvelope soapEnvelope)
            throws SOAPException, XMLStreamException {

        final SOAPPart responsePart = soapResponse.getSOAPPart();
        final NodeList childNodes = responsePart.getChildNodes();

        final NamedNodeMap envelopeAttributes = childNodes.item(0).getAttributes();
        for (int i = 0; i < envelopeAttributes.getLength(); i++) {
            final org.w3c.dom.Node node = envelopeAttributes.item(i);
            final String nodeName = node.getNodeName();
            final Name name = soapEnvelope.createName(nodeName);
            sourceContent.addAttribute(name, node.getNodeValue());
        }

        // Build XML InputStream
        final DOMSource source = new DOMSource(sourceContent);
        final XMLStreamReader reader = inputFactory.createXMLStreamReader(source);
        final StAXSource stAXSource = new StAXSource(reader);
        return stAXSource.getXMLStreamReader();
    }

    @NotNull
    static XMLStreamReader computeCallsPayloadForMethodWithNoParameter(@NotNull String operationName, @NotNull String namespace) throws XMLStreamException {
        String callsPayloadAsString = "<ns0:" + operationName + " xmlns:ns0=\"" + namespace + "\"/>";
        return inputFactory.createXMLStreamReader(new StringReader(callsPayloadAsString));
    }
}
