/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.wsdl.runtime.header;

import javax.xml.soap.SOAPHeader;

/**
 * Exception to be thrown when problems arise creating while {@link SOAPHeader SOAP Headers}.
 *
 * @author martin.paoloni@mulesoft.com
 */
public class SoapHeaderException extends Exception {

    /**
     * Serial Version ID.
     */
    private static final long serialVersionUID = 7322894771315550250L;

    /**
     * Constructs a {@link SoapHeaderException}.
     */
    public SoapHeaderException() {
        super();
    }

    /**
     * Constructs a {@link SoapHeaderException}.
     *
     * @param message
     *            the detail message (which is saved for later retrieval by the getMessage() method).
     * @param cause
     *            the cause (which is saved for later retrieval by the getCause() method). (A null value is permitted, and indicates that the cause is nonexistent or unknown.)
     */
    public SoapHeaderException(final String message, final Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a {@link SoapHeaderException}.
     *
     * @param message
     *            the detail message (which is saved for later retrieval by the getMessage() method).
     */
    public SoapHeaderException(final String message) {
        super(message);
    }

    /**
     * Constructs a {@link SoapHeaderException}.
     *
     * @param cause
     *            the cause (which is saved for later retrieval by the getCause() method). (A null value is permitted, and indicates that the cause is nonexistent or unknown.)
     */
    public SoapHeaderException(final Throwable cause) {
        super(cause);
    }
}
