package org.mule.modules.wsdl.runtime.header;

import javax.xml.soap.SOAPHeader;

import org.jetbrains.annotations.NotNull;
import org.mule.modules.wsdl.runtime.ServiceDefinition;
import org.mule.modules.wsdl.runtime.SoapClient;

/**
 * Interface implemented by SOAP Header Builders to be used by {@link SoapClient WSDL Invoker}.
 *
 * @author martin.paoloni@mulesoft.com
 */
public interface HeaderBuilder {

    void build(@NotNull SOAPHeader header, @NotNull ServiceDefinition serviceDefinition) throws SoapHeaderException;
}
