package org.mule.modules.wsdl.metadataModel;

import org.mule.common.metadata.*;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.property.TextBasedExampleMetaDataModelProperty;

import javax.xml.namespace.QName;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;

/**
 * <p>
 * XML metadata representation
 * </p>
 * <p>
 * Shouldn't use this directly. Use {@link org.mule.common.metadata.builder.DefaultMetaDataBuilder} instead.
 * </p>
 */
public class ConcreteXmlMetaDataModel extends AbstractStructuredMetaDataModel implements XmlMetaDataModel {

    private QName rootElement;
    private SchemaProvider schemas;

    /**
     * @param schemas
     *            The schemas
     * @param sourceUrl
     *            The url where the relative paths will be taken from
     * @param rootElement
     *            The root element QName
     * @param encoding
     *            The encoding of the schemas
     * @param namespaceManager
     *            Additional manager to check namespace usage
     * @param concreteType
     *            The actual type used for the operation
     * @param properties
     *            Additional properties
     */
    public ConcreteXmlMetaDataModel(List<String> schemas, URL sourceUrl, QName rootElement, Charset encoding, XmlMetaDataNamespaceManager namespaceManager, String concreteType,
            MetaDataModelProperty... properties) {
        this(new StringBasedSchemaProvider(schemas, encoding, sourceUrl), rootElement,
                new ConcreteXmlMetaDataTypeFieldFactory(new StringBasedSchemaProvider(schemas, encoding, sourceUrl), rootElement, namespaceManager, concreteType).createFields(),
                namespaceManager, properties);

    }

    /**
     * @param schemas
     *            The schemas
     * @param sourceUrl
     *            The url where the relative paths will be taken from
     * @param elementName
     *            The element QName
     * @param typeElement
     *            The type element QName
     * @param encoding
     *            The encoding of the schemas
     * @param namespaceManager
     *            Additional manager to check namespace usage
     * @param concreteType
     *            The actual type used for the operation
     * @param properties
     *            Additional properties
     */
    public ConcreteXmlMetaDataModel(List<String> schemas, URL sourceUrl, QName elementName, QName typeElement, Charset encoding, XmlMetaDataNamespaceManager namespaceManager,
            String concreteType, MetaDataModelProperty... properties) {
        this(new StringBasedSchemaProvider(schemas, encoding, sourceUrl), elementName,
                new ConcreteXmlMetaDataTypeFieldFactory(new StringBasedSchemaProvider(schemas, encoding, sourceUrl), typeElement, namespaceManager, concreteType).createFields(),
                namespaceManager, properties);

    }

    /**
     * @param schemas
     *            The schemas
     * @param rootElement
     *            The root element QName
     * @param namespaceManager
     *            Additional manager to check namespace usage
     * @param concreteType
     *            The actual type used for the operation
     * @param properties
     *            Additional properties
     */
    public ConcreteXmlMetaDataModel(List<URL> schemas, QName rootElement, XmlMetaDataNamespaceManager namespaceManager, String concreteType, MetaDataModelProperty... properties) {
        this(new UrlBasedSchemaProvider(schemas), rootElement,
                new ConcreteXmlMetaDataTypeFieldFactory(new UrlBasedSchemaProvider(schemas), rootElement, namespaceManager, concreteType).createFields(), namespaceManager,
                properties);

    }

    /**
     * This constructor if for internal use only
     * 
     * @param schemas
     *            The schemas
     * @param rootElement
     *            The root element QName
     * @param properties
     *            Additional properties
     * @param fields
     *            The fields
     * @param namespaceManager
     *            Additional manager to check namespace usage
     */
    ConcreteXmlMetaDataModel(SchemaProvider schemas, QName rootElement, List<MetaDataField> fields, XmlMetaDataNamespaceManager namespaceManager,
            MetaDataModelProperty... properties) {
        super(DataType.XML, fields);
        this.schemas = schemas;
        this.rootElement = namespaceManager.assignPrefixIfNotPresent(rootElement);

        addAllProperties(properties);
    }

    @Override
    public QName getRootElement() {
        return rootElement;
    }

    @Override
    public List<InputStream> getSchemas() {
        return schemas.getSchemas();
    }

    @Override
    public void accept(MetaDataModelVisitor modelVisitor) {
        modelVisitor.visitXmlMetaDataModel(this);
    }

    @Override
    public String getExample() {
        return hasProperty(TextBasedExampleMetaDataModelProperty.class) ? getProperty(TextBasedExampleMetaDataModelProperty.class).getExampleContent() : null;
    }

    @Override
    public void setExample(String xmlExample) {
        addProperty(new TextBasedExampleMetaDataModelProperty(xmlExample));
    }
}
