package org.mule.modules.wsdl.runtime.request.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.jetbrains.annotations.Nullable;
import org.mule.modules.wsdl.datasense.SchemaUtils;
import org.mule.modules.wsdl.runtime.request.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ComplexDocumentBuilder extends DocumentBuilder {

    private Map<String, String> optionalCustomFields;

    public ComplexDocumentBuilder(String type, String xmlElementType) {
        super(type, xmlElementType);
        this.optionalCustomFields = new HashMap<String,String>();
    }

    public ComplexDocumentBuilder(String type, String xmlElementType, Map<String, String> optionalCustomFields) {
        super(type, xmlElementType);
        this.optionalCustomFields = optionalCustomFields;
    }

    public Document createDocument(XMLStreamReader payload) throws ParserConfigurationException, XMLStreamException {
        return enrichPayload(StaxUtils.read(payload));
    }

    private Document enrichPayload(@Nullable Document input) throws ParserConfigurationException, XMLStreamException {

        final String split[] = StringUtils.split(this.getType(), SchemaUtils.DEFINITION_SEPARATOR);
        if (split.length != SchemaUtils.THIRD_LEVEL_COMPONENT_NUMBER && optionalCustomFields.isEmpty()) {
            return input;
        }

        if (input != null) {
            Node operation = input.getFirstChild();
            Node object = operation.getFirstChild();

            while (object != null) {
                if (object.getLocalName() != null && object.getLocalName().equals(this.getXmlElementType())) {
                    Element elementObject = (Element) object;
                    String namespace = elementObject.getFirstChild().getNextSibling().getNamespaceURI();

                    String concreteType = "concrNamespace" + ":" + split[0];
                    Element operationElement = (Element) operation;
                    if (split.length == SchemaUtils.THIRD_LEVEL_COMPONENT_NUMBER) {
                        operationElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");

                        elementObject.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:concrNamespace", namespace);
                        elementObject.setAttribute("xsi:type", concreteType);
                    }

                }
                object = object.getNextSibling();
            }

            for (Entry<String, String> optionalValue : optionalCustomFields.entrySet()) {
                String qualifiedName = operation.getPrefix() + ":" + optionalValue.getKey();
                Element elem = operation.getOwnerDocument().createElementNS(operation.getNamespaceURI(), qualifiedName);
                elem.setTextContent(optionalValue.getValue());
                operation.insertBefore(elem, operation.getFirstChild());
            }
        }

        return input;

    }
}
