/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.wsdl.datasense;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.cxf.catalog.CatalogWSDLLocator;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mule.common.metadata.MetaDataGenerationException;
import org.mule.common.metadata.StringBasedSchemaProvider;
import org.mule.common.metadata.util.XmlSchemaUtils;
import org.mule.modules.wsdl.datasense.WsdlDatasenseException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaUtils {
    public static final int THIRD_LEVEL_COMPONENT_NUMBER = 2;
    public static final String DEFINITION_SEPARATOR = "-";
    private static final Predicate<String> NON_EMPTY_STRING = new Predicate<String>(){

        public boolean apply(@Nullable String input) {
            return StringUtils.isNotBlank((String)input);
        }
    };

    private SchemaUtils() {
    }

    @NotNull
    public static List<String> getSchemas(@NotNull Definition wsdlDefinition) throws TransformerException {
        Map wsdlNamespaces = wsdlDefinition.getNamespaces();
        ArrayList<String> schemas = new ArrayList<String>();
        ArrayList<Types> typesList = new ArrayList<Types>();
        SchemaUtils.extractWsdlTypes(wsdlDefinition, typesList);
        for (Types types : typesList) {
            for (Object o : types.getExtensibilityElements()) {
                if (!(o instanceof Schema)) continue;
                schemas.addAll(SchemaUtils.resolveSchema(wsdlNamespaces, (Schema)o));
            }
        }
        for (Object wsdlImportList : wsdlDefinition.getImports().values()) {
            List importList = (List)wsdlImportList;
            for (Import wsdlImport : importList) {
                schemas.addAll(SchemaUtils.getSchemas(wsdlImport.getDefinition()));
            }
        }
        return schemas;
    }

    @NotNull
    private static List<String> resolveSchema(Map<String, String> wsdlNamespaces, Schema schema) throws TransformerException {
        ArrayList<String> schemas = new ArrayList<String>();
        SchemaUtils.fixPrefix(wsdlNamespaces, schema);
        SchemaUtils.fixSchemaLocations(schema);
        String flatSchema = SchemaUtils.schemaToString(schema);
        schemas.add(flatSchema);
        return schemas;
    }

    private static void extractWsdlTypes(@NotNull Definition wsdlDefinition, @NotNull List<Types> typesList) {
        if (wsdlDefinition.getTypes() != null) {
            typesList.add(wsdlDefinition.getTypes());
        }
    }

    private static void fixPrefix(Map<String, String> wsdlNamespaces, Schema schema) {
        for (Map.Entry<String, String> entry : wsdlNamespaces.entrySet()) {
            boolean isDefault = StringUtils.isEmpty((String)entry.getKey());
            boolean containNamespace = schema.getElement().hasAttribute("xmlns:" + entry.getKey());
            if (isDefault || containNamespace) continue;
            schema.getElement().setAttribute("xmlns:" + entry.getKey(), entry.getValue());
        }
    }

    private static void fixSchemaLocations(Schema schema) {
        String basePath = SchemaUtils.getBasePath(schema.getDocumentBaseURI());
        Map oldImports = schema.getImports();
        Collection values = oldImports.values();
        if (!values.isEmpty()) {
            SchemaUtils.setSchemaLocationUris(basePath, values);
            SchemaUtils.fixImportSchemaLocationInDom(schema, basePath);
        }
    }

    private static void setSchemaLocationUris(String basePath, Collection<? extends List<SchemaImport>> values) {
        for (List<SchemaImport> list : values) {
            for (SchemaImport schemaImport : list) {
                String schemaLocationURI = schemaImport.getSchemaLocationURI();
                if (schemaLocationURI == null || schemaLocationURI.startsWith(basePath) || schemaLocationURI.startsWith("http")) continue;
                schemaImport.setSchemaLocationURI(basePath + schemaLocationURI);
            }
        }
    }

    private static void fixImportSchemaLocationInDom(@NotNull Schema schema, @NotNull String basePath) {
        NodeList children = schema.getElement().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String schemaLocation;
            NamedNodeMap attributes;
            Node namedItem;
            Node item = children.item(i);
            if (!"import".equals(item.getLocalName()) || (namedItem = (attributes = item.getAttributes()).getNamedItem("schemaLocation")) == null || (schemaLocation = namedItem.getNodeValue()).startsWith(basePath) || schemaLocation.startsWith("http")) continue;
            namedItem.setNodeValue(basePath + schemaLocation);
        }
    }

    private static String getBasePath(String documentURI) {
        File document = new File(documentURI);
        if (document.isDirectory()) {
            return documentURI;
        }
        String fileName = document.getName();
        int fileNameIndex = documentURI.lastIndexOf(fileName);
        if (fileNameIndex == -1) {
            return documentURI;
        }
        return documentURI.substring(0, fileNameIndex);
    }

    private static String schemaToString(Schema schema) throws TransformerException {
        return SchemaUtils.elementToString(schema.getElement());
    }

    private static String elementToString(Element element) throws TransformerException {
        StringWriter writer = new StringWriter();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(new DOMSource(element), new StreamResult(writer));
        return writer.toString();
    }

    public static List<SchemaType> getExtendingTypes(List<String> listOfschemas, URL sourceUrl, QName rootElementName, Charset encoding) {
        try {
            SchemaProperty[] properties;
            StringBasedSchemaProvider schemas = new StringBasedSchemaProvider(listOfschemas, encoding, sourceUrl);
            ArrayList<SchemaType> returnedTypes = new ArrayList<SchemaType>();
            SchemaTypeSystem schemaTypeLoader = XmlSchemaUtils.getSchemaTypeSystem(listOfschemas, null);
            SchemaType[] listOfElements = schemaTypeLoader.globalTypes();
            SchemaGlobalElement rootElement = schemas.findRootElement(rootElementName);
            SchemaType type = rootElement.getType();
            for (SchemaProperty property : properties = type.getProperties()) {
                final SchemaType propertyType = property.getType();
                if (SchemaUtils.hasSimpleContentOnly(propertyType)) continue;
                Iterables.concat(returnedTypes, (Iterable)Iterables.filter(Arrays.asList(listOfElements), (Predicate)new Predicate<SchemaType>(){

                    public boolean apply(SchemaType input) {
                        return input.getBaseType().getName().equals(propertyType.getName());
                    }
                }));
                for (SchemaType schType : listOfElements) {
                    if (!schType.getBaseType().getName().equals(propertyType.getName())) continue;
                    returnedTypes.add(schType);
                }
            }
            return returnedTypes;
        }
        catch (XmlException e) {
            throw new MetaDataGenerationException((Throwable)e);
        }
    }

    public static List<String> getExtendingTypeNames(@NotNull Iterable<URL> wsdlURLs, URL sourceUrl, QName elName, Charset encoding) throws WSDLException, WsdlDatasenseException {
        WSDLFactory factory = WSDLFactory.newInstance();
        ArrayList<String> returnedTypeList = new ArrayList<String>();
        for (URL wsdlURL : wsdlURLs) {
            try {
                URI wsdlURI = new URI(wsdlURL.toString());
                Definition wsdlDefinition = factory.newWSDLReader().readWSDL((WSDLLocator)new CatalogWSDLLocator(wsdlURI.toString()));
                List<SchemaType> schemaTypes = SchemaUtils.getExtendingTypes(SchemaUtils.getSchemas(wsdlDefinition), sourceUrl, elName, encoding);
                for (SchemaType schemaType : schemaTypes) {
                    returnedTypeList.add(schemaType.getName().getLocalPart());
                }
            }
            catch (URISyntaxException e) {
                throw new WsdlDatasenseException(e);
            }
            catch (WSDLException e) {
                throw new WsdlDatasenseException(e);
            }
            catch (TransformerException e) {
                throw new WsdlDatasenseException(e);
            }
        }
        return returnedTypeList;
    }

    public static SchemaType getExtendingType(List<String> listOfschemas, SchemaType propertyType, final String extendingType) {
        try {
            SchemaTypeSystem schemaTypeLoader = XmlSchemaUtils.getSchemaTypeSystem(listOfschemas, null);
            SchemaType[] listOfElements = schemaTypeLoader.globalTypes();
            if (!SchemaUtils.hasSimpleContentOnly(propertyType)) {
                return (SchemaType)Iterables.find(Arrays.asList(listOfElements), (Predicate)new Predicate<SchemaType>(){

                    public boolean apply(SchemaType input) {
                        return input.getName().getLocalPart().equals(extendingType);
                    }
                });
            }
            return null;
        }
        catch (XmlException e) {
            throw new MetaDataGenerationException((Throwable)e);
        }
    }

    public static String makeReadable(String original) {
        String temporary = original.replace('_', ' ');
        Object[] strings = StringUtils.splitByCharacterTypeCamelCase((String)temporary);
        return WordUtils.capitalizeFully((String)org.apache.commons.lang3.StringUtils.join((Iterable)Iterables.filter((Iterable)Lists.newArrayList((Object[])strings), NON_EMPTY_STRING), (String)" "));
    }

    public static boolean hasSimpleContentOnly(SchemaType type) {
        return SchemaUtils.hasSimpleContent(type) && ArrayUtils.isEmpty((Object[])type.getAttributeProperties()) && ArrayUtils.isEmpty((Object[])type.getElementProperties());
    }

    public static boolean hasSimpleContent(SchemaType type) {
        return type.isSimpleType() || type.getContentType() == 2 || type.getContentType() == 4 || type.getComponentType() == 1;
    }
}

