package org.mule.modules.wsdl.datasense.binding;

import com.google.common.collect.Iterables;
import org.apache.xmlbeans.SchemaType;
import org.mule.devkit.api.metadata.ComposedMetaDataKey;
import org.mule.devkit.api.metadata.ComposedMetaDataKeyBuilder;
import org.mule.modules.wsdl.datasense.SchemaUtils;
import org.mule.modules.wsdl.datasense.WsdlDatasenseException;
import org.mule.modules.wsdl.runtime.CallDefinition;
import org.mule.modules.wsdl.runtime.ServiceDefinition;

import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import java.net.URL;
import java.util.List;
import java.util.Map;

import static org.mule.modules.wsdl.datasense.SchemaUtils.DEFINITION_SEPARATOR;

public abstract class BindingHelper {

    protected ComposedMetaDataKey getComposedMetaDataKey(final String wsdlName, final String firstLevelLabel, final BindingOperation bindingOperation) {
        final String operationName = bindingOperation.getOperation().getName();
        final CallDefinition callDefinition = new CallDefinition(wsdlName, operationName);
        final String secondLevelLabel = SchemaUtils.makeReadable(operationName);

        final List<ComposedMetaDataKey> composedMetaDataKeys = ComposedMetaDataKeyBuilder.getInstance().newKeyCombination().newLevel()
                .addId(callDefinition.getEndpointPath(), firstLevelLabel).endLevel().newLevel().addId(callDefinition.getOperationName(), secondLevelLabel).endLevel()
                .endKeyCombination().build();
        return composedMetaDataKeys.get(0);
    }

    protected ComposedMetaDataKey getComposedMetaDataKey(final String firstLevelLabel, ServiceDefinition serviceDef,
            CallDefinition callDefinition, SchemaType result, String secondLevelLabel) {

        ComposedMetaDataKeyBuilder keyBuilder;

        if (result == null) {
            final String UNDEFINED = "Undefined";
            String thirdLabel = SchemaUtils.makeReadable(UNDEFINED);
            keyBuilder = ComposedMetaDataKeyBuilder.getInstance().newKeyCombination().newLevel()
                    .addId(serviceDef.getServiceName() + DEFINITION_SEPARATOR + serviceDef.getPortName() + DEFINITION_SEPARATOR + serviceDef.getNamespace(),
                            firstLevelLabel)
                    .endLevel().newLevel().addId(callDefinition.getOperationName(), secondLevelLabel).endLevel().newLevel().addId(UNDEFINED, thirdLabel).endLevel()
                    .endKeyCombination();

        } else {
            String thirdLabel = SchemaUtils.makeReadable(result.getName().getLocalPart());
            keyBuilder = ComposedMetaDataKeyBuilder.getInstance().newKeyCombination().newLevel()
                    .addId(serviceDef.getServiceName() + DEFINITION_SEPARATOR + serviceDef.getPortName() + DEFINITION_SEPARATOR + serviceDef.getNamespace(),
                            firstLevelLabel)
                    .endLevel().newLevel().addId(callDefinition.getOperationName(), secondLevelLabel).endLevel().newLevel()
                    .addId(result.getName().getLocalPart() + DEFINITION_SEPARATOR + result.getBaseType().getName().getLocalPart(), thirdLabel).endLevel()
                    .endKeyCombination();
        }
        return Iterables.getFirst(keyBuilder.build(), null);
    }

    public abstract void addMetadataForBinding(List<ComposedMetaDataKey> metaDataKeys, Map<String, URL> metaDataKeysUrls, final Definition wsdlDefinition, final String wsdlName,
            final String firstLevelLabel, final Map<QName, Binding> bindings, final String category) throws WsdlDatasenseException;

}
