package org.mule.modules.wsdl.datasense.binding;

import com.ibm.wsdl.ServiceImpl;
import org.apache.xmlbeans.SchemaType;
import org.mule.devkit.api.metadata.ComposedMetaDataKey;
import org.mule.devkit.internal.metadata.DefaultComposedMetaDataKey;
import org.mule.modules.wsdl.datasense.SchemaUtils;
import org.mule.modules.wsdl.datasense.WsdlDatasenseException;
import org.mule.modules.wsdl.runtime.CallDefinition;
import org.mule.modules.wsdl.runtime.ServiceDefinition;

import javax.wsdl.*;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

public class ConcreteBindingHelper extends BindingHelper {

    private Message getInputMessage(final Operation operation) {
        return operation.getInput().getMessage();
    }

    @Override
    @SuppressWarnings("unchecked")
    public void addMetadataForBinding(List<ComposedMetaDataKey> metaDataKeys, Map<String, URL> metaDataKeysUrls, final Definition wsdlDefinition, final String wsdlName,
            String firstLevelLabel, final Map<QName, Binding> bindings, final String category) throws WsdlDatasenseException {

        URL wsdlURL;
        try {
            wsdlURL = new URL(wsdlDefinition.getDocumentBaseURI());
            for (final QName ignored : bindings.keySet()) {
                Map<QName, ServiceImpl> serviceMap = wsdlDefinition.getServices();
                for (Map.Entry<QName, ServiceImpl> service : serviceMap.entrySet()) {
                    firstLevelLabel = SchemaUtils.makeReadable(firstLevelLabel + SchemaUtils.DEFINITION_SEPARATOR + service.getKey().getLocalPart());
                    Map<String, Port> ports = service.getValue().getPorts();
                    String serviceNamespace = service.getValue().getQName().getNamespaceURI();
                    if (serviceNamespace == null) {
                        throw new WsdlDatasenseException("Service: " + service.getKey().getLocalPart() + " does not have a namespace");
                    }
                    for (Map.Entry<String, Port> portName : ports.entrySet()) {

                        for (final Object bindingOperation : portName.getValue().getBinding().getBindingOperations()) {
                            List<SchemaType> result;

                            final String operationName = ((BindingOperation) bindingOperation).getOperation().getName();
                            final CallDefinition callDefinition = new CallDefinition(wsdlName, operationName);
                            final String secondLevelLabel = SchemaUtils.makeReadable(operationName);
                            final Message message = getInputMessage(((BindingOperation) bindingOperation).getOperation());

                            QName elName = null;
                            if (message != null && message.getParts() != null) {
                                Map<String, Part> parts = message.getParts();
                                for (Map.Entry<String, Part> part : parts.entrySet()) {
                                    elName = part.getValue().getElementName();
                                }
                                try {
                                    result = SchemaUtils.getExtendingTypes(SchemaUtils.getSchemas(wsdlDefinition), null, elName, Charset.defaultCharset());
                                } catch (TransformerException e) {
                                    throw new WsdlDatasenseException("Cannot properly parse the SimpleWsdlAndOperation", e);
                                }
                                ServiceDefinition serviceDef = ServiceDefinition.create(serviceNamespace, service.getKey().getLocalPart(), portName.getKey(), null, null);
                                for (SchemaType schemaResult : result) {
                                    final ComposedMetaDataKey composedMetaDataKey = getComposedMetaDataKey(firstLevelLabel, serviceDef,
                                            callDefinition, schemaResult, secondLevelLabel);
                                    ((DefaultComposedMetaDataKey) composedMetaDataKey).setCategory(category);
                                    metaDataKeys.add(composedMetaDataKey);
                                    metaDataKeysUrls.put(composedMetaDataKey.getId(), wsdlURL);
                                }
                                if (result.isEmpty()) {
                                    final ComposedMetaDataKey composedMetaDataKey = getComposedMetaDataKey(firstLevelLabel, serviceDef,
                                            callDefinition, null, secondLevelLabel);
                                    ((DefaultComposedMetaDataKey) composedMetaDataKey).setCategory(category);
                                    metaDataKeys.add(composedMetaDataKey);
                                    metaDataKeysUrls.put(composedMetaDataKey.getId(), wsdlURL);
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (MalformedURLException e) {
            throw new WsdlDatasenseException(e);
        }
    }
}
