package org.mule.modules.wsdl.datasense.binding;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;

import org.mule.devkit.api.metadata.ComposedMetaDataKey;
import org.mule.devkit.internal.metadata.DefaultComposedMetaDataKey;
import org.mule.modules.wsdl.datasense.WsdlDatasenseException;

public class DefaultBindingHelper extends BindingHelper {

    @Override
    public void addMetadataForBinding(List<ComposedMetaDataKey> metaDataKeys, Map<String, URL> metaDataKeysUrls, final Definition wsdlDefinition, final String wsdlName,
            final String firstLevelLabel, final Map<QName, Binding> bindings, final String category) throws WsdlDatasenseException {

        try {
            for (final Entry<QName, Binding> bindingEntry : bindings.entrySet()) {
                URL wsdlURL = new URL(wsdlDefinition.getDocumentBaseURI());
                for (final Object bindingOperation : bindingEntry.getValue().getBindingOperations()) {

                    final ComposedMetaDataKey composedMetaDataKey = getComposedMetaDataKey(wsdlName, firstLevelLabel, (BindingOperation) bindingOperation);
                    ((DefaultComposedMetaDataKey) composedMetaDataKey).setCategory(category);
                    metaDataKeys.add(composedMetaDataKey);
                    metaDataKeysUrls.put(composedMetaDataKey.getId(), wsdlURL);
                }
            }
        } catch (MalformedURLException e) {
            throw new WsdlDatasenseException(e);
        }
    }
}
