package org.mule.modules.wsdl.metadataModel;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.apache.commons.io.IOUtils;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlException;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefaultMetaDataField;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaDataField;
import org.mule.common.metadata.MetaDataGenerationException;
import org.mule.common.metadata.SchemaProvider;
import org.mule.common.metadata.XmlMetaDataFieldFactory;
import org.mule.common.metadata.XmlMetaDataModel;
import org.mule.common.metadata.XmlMetaDataNamespaceManager;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.property.LabelMetaDataProperty;
import org.mule.common.metadata.property.QNameMetaDataProperty;
import org.mule.common.metadata.property.xml.AttributeMetaDataFieldProperty;
import org.mule.common.metadata.property.xml.UnboundMetaDataProperty;
import org.mule.modules.wsdl.datasense.SchemaUtils;

import static org.mule.modules.wsdl.datasense.SchemaUtils.DEFINITION_SEPARATOR;

public class ConcreteXmlMetaDataTypeFieldFactory extends XmlMetaDataFieldFactory {

    private XmlMetaDataNamespaceManager namespaceManager;

    private SchemaProvider schemas;
    private QName rootElementName;
    private String[] elementType;

    private static final Map<QName, DataType> typeMapping = new HashMap<QName, DataType>();

    public ConcreteXmlMetaDataTypeFieldFactory(SchemaProvider schemas, QName typeElementName, XmlMetaDataNamespaceManager namespaceManager, String elementType) {
        super(schemas, typeElementName, namespaceManager);
        this.namespaceManager = namespaceManager;
        this.schemas = schemas;
        this.elementType = elementType.split(DEFINITION_SEPARATOR);
        this.rootElementName = typeElementName;
    }

    @Override
    public List<MetaDataField> createFields() {
        try {
            List<MetaDataField> metaDataFields = new ArrayList<MetaDataField>();
            final Map<SchemaType, XmlMetaDataModel> visitedTypes = new HashMap<SchemaType, XmlMetaDataModel>();

            SchemaGlobalElement rootElement = schemas.findRootElement(getRootElementName());

            if (rootElement != null) {
                SchemaType type = rootElement.getType();
                int level = 1;
                loadFields(type, metaDataFields, visitedTypes, level);
            }
            return metaDataFields;
        } catch (XmlException e) {
            throw new MetaDataGenerationException(e);
        }

    }

    private void loadFields(SchemaType type, List<MetaDataField> metaDataFields, Map<SchemaType, XmlMetaDataModel> visitedTypes, int level) {

        List<String> schemaList = new ArrayList<String>();
        String concreteElement = null;
        for (int i = 0; i < schemas.getSchemas().size(); i++) {
            try {
                schemaList.add(IOUtils.toString(schemas.getSchemas().get(i)));
            } catch (IOException e) {
                throw new MetaDataGenerationException(e);
            }
        }

        if (SchemaUtils.hasSimpleContent(type)) {
            final DataType dataType = getDataType(type, DataType.STRING);
            metaDataFields.add(new DefaultMetaDataField(TEXT, new DefaultSimpleMetaDataModel(dataType), new QNameMetaDataProperty(new QName(TEXT))));
        }
        final SchemaProperty[] properties = type.getProperties();
        for (SchemaProperty property : properties) {
            final QName name = namespaceManager.assignPrefixIfNotPresent(property.getName());
            final SchemaType propertyType = property.getType();
            if (property.isAttribute()) {
                final DataType dataType = getDataType(propertyType, DataType.STRING);
                metaDataFields.add(new DefaultMetaDataField(toLabel(name), new DefaultSimpleMetaDataModel(dataType), new QNameMetaDataProperty(name),
                        new LabelMetaDataProperty(toAttributeLabel(name)), new AttributeMetaDataFieldProperty(true)));
            } else if (isList(property)) {
                if (SchemaUtils.hasSimpleContentOnly(propertyType)) {
                    final DataType dataType = getDataType(propertyType, DataType.STRING);
                    final DefaultListMetaDataModel defaultListMetaDataModel = new DefaultListMetaDataModel(new DefaultSimpleMetaDataModel(dataType));
                    defaultListMetaDataModel.addProperty(getUnboundProperty(property));
                    metaDataFields.add(new DefaultMetaDataField(toLabel(name), defaultListMetaDataModel, new QNameMetaDataProperty(name)));
                } else {
                    SchemaType concreteType = null;
                    if (elementType.length == SchemaUtils.THIRD_LEVEL_COMPONENT_NUMBER) {
                        concreteElement = elementType[0];
                    }
                    if (concreteElement != null && propertyType.getName() != null && elementType[1].equals(propertyType.getName().getLocalPart()) && level == 1) {
                        concreteType = SchemaUtils.getExtendingType(schemaList, propertyType, concreteElement);
                    }

                    if (concreteType == null) {
                        concreteType = propertyType;
                    }
                    final XmlMetaDataModel model = buildXMLMetaDataModel(visitedTypes, concreteType, level);
                    final DefaultListMetaDataModel defaultListMetaDataModel = new DefaultListMetaDataModel(model);

                    defaultListMetaDataModel.addProperty(getUnboundProperty(property));
                    metaDataFields.add(new DefaultMetaDataField(toLabel(name), defaultListMetaDataModel, new QNameMetaDataProperty(name)));
                }
            } else {
                if (SchemaUtils.hasSimpleContentOnly(propertyType)) {
                    final DataType dataType = getDataType(propertyType, DataType.STRING);
                    metaDataFields.add(new DefaultMetaDataField(toLabel(name), new DefaultSimpleMetaDataModel(dataType), new QNameMetaDataProperty(name)));
                } else {
                    SchemaType concreteType = null;
                    if (elementType.length == SchemaUtils.THIRD_LEVEL_COMPONENT_NUMBER) {
                        concreteElement = elementType[0];
                    }
                    if (concreteElement != null && propertyType.getName() != null && elementType[1].equals(propertyType.getName().getLocalPart()) && level == 1) {
                        concreteType = SchemaUtils.getExtendingType(schemaList, propertyType, concreteElement);
                    }
                    if (concreteType == null) {
                        concreteType = propertyType;
                    }
                    final XmlMetaDataModel model = buildXMLMetaDataModel(visitedTypes, concreteType, level);
                    metaDataFields.add(new DefaultMetaDataField(toLabel(name), model, new QNameMetaDataProperty(name)));
                }
            }
        }
    }

    private String toLabel(QName name) {
        if (namespaceManager.isPrefixDeclared(name)) {
            return name.getPrefix() + ":" + name.getLocalPart();
        } else {
            return name.getLocalPart();
        }
    }

    private UnboundMetaDataProperty getUnboundProperty(SchemaProperty property) {
        final BigInteger maxOccurs = property.getMaxOccurs();
        final BigInteger minOccurs = property.getMinOccurs();
        int max = maxOccurs == null ? Integer.MAX_VALUE : maxOccurs.intValue();
        int min = minOccurs == null ? 0 : minOccurs.intValue();
        return new UnboundMetaDataProperty(min, max);
    }

    private DataType getDataType(SchemaType type, DataType defaultDataType) {
        SchemaType simpleType = getSimpleBaseType(type);

        do {
            DataType fieldType = typeMapping.get(simpleType.getName());
            if (fieldType != null) {
                return fieldType;
            }

            simpleType = simpleType.getBaseType();
        } while (simpleType != null);

        return defaultDataType;
    }

    private boolean isList(SchemaProperty property) {
        BigInteger maxOccurs = property.getMaxOccurs();
        return maxOccurs == null || property.getMaxOccurs().intValue() > 1;
    }

    private static SchemaType getSimpleBaseType(SchemaType type) {
        SchemaType basic = type;
        while (basic.getBaseType() != null && !basic.isSimpleType()) {
            basic = basic.getBaseType();
        }

        return basic;
    }

    private XmlMetaDataModel buildXMLMetaDataModel(Map<SchemaType, XmlMetaDataModel> visitedTypes, SchemaType propertyType, int level) {
        XmlMetaDataModel model;
        if (visitedTypes.containsKey(propertyType)) {
            model = visitedTypes.get(propertyType);
        } else {
            final ArrayList<MetaDataField> fields = new ArrayList<MetaDataField>();
            model = new ConcreteXmlMetaDataModel(schemas, rootElementName, fields, namespaceManager);
            visitedTypes.put(propertyType, model);
            loadFields(propertyType, fields, visitedTypes, level + 1);
        }
        return model;
    }

    private String toAttributeLabel(QName name) {
        return "@" + toLabel(name);
    }

}
