package org.mule.modules.wsdl.runtime;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoapCallException extends Exception {

    private static final long serialVersionUID = 1965767113473619186L;

    private SoapCallException(@NotNull final String message, @Nullable final Throwable cause) {
        super(message, cause);
    }

    @NotNull
    static SoapCallException createCallException(@NotNull final Throwable e) {
        return new SoapCallException("Invocation could not be completed successfully." + e.getLocalizedMessage(), e);
    }

    @NotNull
    static SoapCallException createMetadataInvocationException(@Nullable final String type) {
        return new SoapCallException("SOAP invocation can not be performed. Operation metadata is invalid '" + type + "'. Review the invocation parameters.", null);
    }

}
