package org.mule.modules.wsdl.metadataModel;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.apache.commons.io.IOUtils;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.XmlMetaDataModel;
import org.mule.common.metadata.XmlMetaDataNamespaceManager;
import org.mule.common.metadata.builder.DefaultMetaDataBuilder;
import org.mule.common.metadata.builder.DefaultXmlMetaDataBuilder;
import org.mule.common.metadata.builder.MetaDataBuilder;
import org.mule.common.metadata.builder.XmlMetaDataBuilder;
import org.mule.common.metadata.property.DescriptionMetaDataProperty;
import org.mule.common.metadata.property.LabelMetaDataProperty;
import org.mule.common.metadata.property.TextBasedExampleMetaDataModelProperty;
import org.mule.common.metadata.property.xml.XsiTypeMetaDataProperty;

public class ConcreteTypeXmlMetadataBuilder<P extends MetaDataBuilder<MetaDataModel>> extends DefaultXmlMetaDataBuilder<P> {

    private XmlMetaDataBuilder<P> defaultBehavior;

    public ConcreteTypeXmlMetadataBuilder(QName elementType) {
        super(elementType);
        defaultBehavior = new DefaultMetaDataBuilder().createXmlObject(elementType);
    }

    private String label;
    private String description;
    private URL sourceUrl;
    private String concreteType;
    private XmlMetaDataNamespaceManager namespaceManager = new XmlMetaDataNamespaceManager();

    public ConcreteTypeXmlMetadataBuilder withConcreteType(String concreteType) {
        this.concreteType = concreteType;
        return this;
    }

    @Override
    public XmlMetaDataModel build() {
        return concreteType == null ? defaultBehavior.build() : concreteBuild();
    }

    private XmlMetaDataModel concreteBuild() {

        XmlMetaDataModel model = null;

        if (schemasStream != null) {
            List<String> result = new ArrayList<String>();
            for (InputStream schemaStream : schemasStream) {
                result.add(getStringFromInputStream(schemaStream, encoding));
            }
            schemas = result;
        }

        // currently there is an improvment request to improve the functionality of XsiProperty. Now this property does nothing but we keep
        // this to use when the improvment is made
        if (type == null) {
            if (schemas == null) {
                if (schemasUrls != null) {
                    model = new ConcreteXmlMetaDataModel(schemasUrls, name, namespaceManager, concreteType, new TextBasedExampleMetaDataModelProperty(example));
                }
            } else {
                model = new ConcreteXmlMetaDataModel(schemas, sourceUrl, name, encoding, namespaceManager, concreteType, new TextBasedExampleMetaDataModelProperty(example));
            }

        } else {
            if (schemas == null) {
                if (schemasUrls != null) {
                    model = new ConcreteXmlMetaDataModel(schemasUrls, name, namespaceManager, concreteType, new TextBasedExampleMetaDataModelProperty(example));
                }
            } else {
                model = new ConcreteXmlMetaDataModel(schemas, sourceUrl, name, type, encoding, namespaceManager, concreteType, new TextBasedExampleMetaDataModelProperty(example),
                        new XsiTypeMetaDataProperty(type));
            }

        }
        if (model != null) {
            if (label != null) {
                model.addProperty(new LabelMetaDataProperty(label));
            }

            if (description != null) {
                model.addProperty(new DescriptionMetaDataProperty(description));
            }

            if (type != null) {
                model.addProperty(new XsiTypeMetaDataProperty(type));
            }
        }
        return model;
    }

    private static String getStringFromInputStream(InputStream is, Charset encoding) {
        try {
            if (encoding == null) {
                return IOUtils.toString(is);
            } else {
                return IOUtils.toString(is, encoding.toString());
            }
        } catch (IOException ex) {
            // This is not likely to happen as we are reading from memory (Strings)
            throw new RuntimeException("Failed to turn input stream into string with encoding [" + encoding + "]", ex);
        }

    }

    public DefaultXmlMetaDataBuilder<P> setSourceUri(URL sourceUrl) {
        this.sourceUrl = sourceUrl;
        return super.setSourceUri(sourceUrl);
    }

    @Override
    public DefaultXmlMetaDataBuilder<P> addSchemaStringList(String... schemas) {
        defaultBehavior.addSchemaStringList(schemas);
        return super.addSchemaStringList(schemas);
    }

    public DefaultXmlMetaDataBuilder<P> addSchemaStreamList(InputStream... schemaStreams) {
        defaultBehavior.addSchemaStreamList(schemaStreams);
        return super.addSchemaStreamList(schemaStreams);
    }

    public DefaultXmlMetaDataBuilder<P> addSchemaUrlList(URL... schemaStreams) {
        defaultBehavior.addSchemaUrlList(schemaStreams);
        return super.addSchemaUrlList(schemaStreams);
    }

    public DefaultXmlMetaDataBuilder<P> setEncoding(Charset encoding) {
        defaultBehavior.setEncoding(encoding);
        return super.setEncoding(encoding);
    }

    // TODO: Check if needed
    public DefaultXmlMetaDataBuilder<P> setExample(String xmlExample) {
        defaultBehavior.setExample(xmlExample);
        return super.setExample(xmlExample);
    }

    public DefaultXmlMetaDataBuilder<P> setLabel(String label) {
        defaultBehavior.setLabel(label);
        return super.setLabel(label);
    }

    public DefaultXmlMetaDataBuilder<P> setDescription(String description) {
        defaultBehavior.setDescription(description);
        return super.setDescription(description);
    }

    public DefaultXmlMetaDataBuilder<P> setType(QName qName) {
        defaultBehavior.setType(qName);
        return super.setType(qName);
    }
}
