%dw 2.0
ns xsi http://www.w3.org/2001/XMLSchema-instance
output application/xml  defaultNamespace="http://maven.apache.org/POM/4.0.0"
input payload
input versions
---
{
  project @(xsi#schemaLocation: "http://maven.apache.org/POM/4.0.0 https://maven.apache.org/xsd/maven-4.0.0.xsd"): {
    modelVersion: "4.0.0",
    groupId: payload.groupId,
    artifactId: payload.assetId,
    version: payload.version,
    packaging: "mule-application",
    name: payload.assetId,
    properties: {
      "project.build.sourceEncoding": "UTF-8",
      "project.reporting.outputEncoding": "UTF-8",
      "app.runtime": "4.9.7",
      "mule.maven.plugin.version": "4.3.0",
      "mule-sockets-connector.version": "1.2.7",
      "mule-http-connector.version": "1.11.0",
      "mule-agent-router-module.version": versions.agentRouterModuleVersion default "0.6.0-SNAPSHOT",
      "mule-mcp-connector.version": versions.mcpConnectorVersion default "1.3.0",
      "mule4-a2a-connector.version": versions.a2aConnectorVersion default "0.4.0-BETA",
    },
    build: {
      plugins: {
        plugin: {
          groupId: "org.apache.maven.plugins",
          artifactId: "maven-clean-plugin",
          version: "3.2.0"
        },
        plugin: {
          groupId: "org.mule.tools.maven",
          artifactId: "mule-maven-plugin",
          version: "\${mule.maven.plugin.version}",
          extensions: "true"
        }
      }
    },
    dependencies: {
      dependency: {
        groupId: "org.mule.connectors",
        artifactId: "mule-http-connector",
        version: "\${mule-http-connector.version}",
        classifier: "mule-plugin"
      },
      dependency: {
        groupId: "org.mule.connectors",
        artifactId: "mule-sockets-connector",
        version: "\${mule-sockets-connector.version}",
        classifier: "mule-plugin"
      },
      dependency: {
        groupId: "com.mulesoft.connectors",
        artifactId: "mule4-a2a-connector",
        version: "\${mule4-a2a-connector.version}",
        classifier: "mule-plugin"
      },
      dependency: {
        groupId: "com.mulesoft.modules",
        artifactId: "mule-agent-router-module",
        version: "\${mule-agent-router-module.version}",
        classifier: "mule-plugin"
      },
      dependency: {
        groupId: "com.mulesoft.connectors",
        artifactId: "mule-mcp-connector",
        version: "\${mule-mcp-connector.version}",
        classifier: "mule-plugin"
      },
    },
    repositories: {
      repository: {
        id: "anypoint-exchange-v3",
        name: "Anypoint Exchange",
        url: "https://maven.anypoint.mulesoft.com/api/v3/maven",
        layout: "default"
      },
      repository: {
        id: "mulesoft-releases",
        name: "MuleSoft Releases Repository",
        url: "https://repository.mulesoft.org/releases/",
        layout: "default"
      },
      repository: {
        id: "mulesoft-snapshots",
        name: "MuleSoft Snapshots Repository",
        url: "https://repository.mulesoft.org/snapshots/",
        layout: "default"
      }
    },
    pluginRepositories: {
      pluginRepository: {
        id: "mulesoft-releases",
        name: "MuleSoft Releases Repository",
        layout: "default",
        url: "https://repository.mulesoft.org/releases/",
        snapshots: {
          enabled: "false"
        }
      }
    }
  }
}
