/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.agent.mojo;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.networknt.schema.AbsoluteIri;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.resource.InputStreamSource;
import com.networknt.schema.resource.SchemaLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.mule.maven.exchange.model.ExchangeModel;
import org.mule.maven.exchange.model.ExchangeModelSerializer;
import org.mule.weave.v2.model.ServiceManager;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveResult;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ScriptingBindings;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import scala.Option;

@Mojo(name="compile-agent-app", defaultPhase=LifecyclePhase.COMPILE)
public class CompileAgentAppMojo
extends AbstractMojo {
    private static final String EXCHANGE_JSON = "exchange.json";
    public static final String MULE_ARTIFACT_JSON = "mule-artifact.json";
    public static final String LOG4J_CONFIG = "app-log4j.xml";
    public static final String MULE_AGENT_XML = "mule-agent.xml";
    public static final String APPLICATION_YAML = "application/yaml";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_JAVA = "application/java";
    public static final String AGENTS_FOLDER = "agents";
    public static final String EXTERNAL_AGENTS_FOLDER = "external-agents";
    public static final String EXTERNAL_MCP_FOLDER = "external-mcp";
    @Component
    private MavenProject project;
    @Component
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    @Component
    protected MavenProjectHelper helper;
    private final ExchangeModelSerializer exchangeModelSerializer = new ExchangeModelSerializer();
    private DataWeaveScriptingEngine dataWeaveScriptingEngine = new DataWeaveScriptingEngine();
    @Parameter(defaultValue="${project.build.directory}/agent-mule-app", readonly=true)
    private File outputDirectory;
    @Parameter(defaultValue="8081")
    private String port;
    @Parameter(defaultValue="http://localhost:8081", name="agent-fabric-gw-url")
    private String agentFabricGwUrl;

    public void execute() throws MojoExecutionException {
        ExchangeModel exchangeModel;
        File exchangeJsonFile = new File(this.project.getBasedir(), EXCHANGE_JSON);
        try {
            exchangeModel = this.exchangeModelSerializer.read(exchangeJsonFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error occurred while reading exchange.json.", (Exception)e);
        }
        String main = exchangeModel.getMain();
        File mainFile = new File(this.project.getBasedir(), main);
        if (!mainFile.exists()) {
            throw new MojoExecutionException("Invalid main: " + main + " in exchange.json as it doesn't exists");
        }
        this.validateMainFile(mainFile);
        this.generateMuleApp(mainFile, exchangeJsonFile);
        this.buildMuleApp();
        this.generateAgentsCard(mainFile, exchangeJsonFile);
        this.generateExternalAgents(mainFile, exchangeJsonFile);
        this.generateExternalMCP(mainFile, exchangeJsonFile);
    }

    public void generateAgentsCard(File mainFile, File exchangeJsonFile) throws MojoExecutionException {
        DataWeaveScript cardExtractor = this.dataWeaveScriptingEngine.compile(NameIdentifier.apply((String)"AgentCardExtractor", (Option)Option.empty()));
        DataWeaveScript cardWriter = this.dataWeaveScriptingEngine.compile("input payload output json --- payload");
        DataWeaveScript exchangeJsonGenerator = this.dataWeaveScriptingEngine.compile(NameIdentifier.apply((String)"AgentExchangeJsonGenerator", (Option)Option.empty()));
        try (FileInputStream value = new FileInputStream(mainFile);){
            DataWeaveResult write = cardExtractor.write(new ScriptingBindings().addBinding("payload", (Object)value, APPLICATION_YAML), ServiceManager.apply());
            Object content = write.getContent();
            File buildDirectory = new File(this.project.getBuild().getDirectory(), AGENTS_FOLDER);
            buildDirectory.mkdirs();
            if (content instanceof Map) {
                Map agents = (Map)content;
                for (Map.Entry agentObject : agents.entrySet()) {
                    String agentName = (String)agentObject.getKey();
                    File agentDirectory = new File(buildDirectory, agentName);
                    agentDirectory.mkdirs();
                    File cardFile = new File(agentDirectory, agentName + "-card.json");
                    cardWriter.write(new ScriptingBindings().addBinding("payload", agentObject.getValue(), APPLICATION_JAVA), ServiceManager.apply(), Option.apply((Object)cardFile));
                    ScriptingBindings bindings = new ScriptingBindings().addBinding("exchangeJson", (Object)exchangeJsonFile, APPLICATION_JSON).addBinding("agentName", (Object)agentName, APPLICATION_JAVA).addBinding("agent", agentObject.getValue(), APPLICATION_JAVA);
                    exchangeJsonGenerator.write(bindings, ServiceManager.apply(), Option.apply((Object)new File(agentDirectory, EXCHANGE_JSON)));
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    public void generateExternalAgents(File mainFile, File exchangeJsonFile) throws MojoExecutionException {
        DataWeaveScript externalAgentExtractor = this.dataWeaveScriptingEngine.compile(NameIdentifier.apply((String)"ExternalAgentExtractor", (Option)Option.empty()));
        DataWeaveScript connectionWriter = this.dataWeaveScriptingEngine.compile("input payload output json --- payload");
        DataWeaveScript exchangeJsonGenerator = this.dataWeaveScriptingEngine.compile(NameIdentifier.apply((String)"AgentExchangeJsonGenerator", (Option)Option.empty()));
        try (FileInputStream value = new FileInputStream(mainFile);){
            DataWeaveResult write = externalAgentExtractor.write(new ScriptingBindings().addBinding("payload", (Object)value, APPLICATION_YAML), ServiceManager.apply());
            Object content = write.getContent();
            File buildDirectory = new File(this.project.getBuild().getDirectory(), EXTERNAL_AGENTS_FOLDER);
            buildDirectory.mkdirs();
            if (content instanceof Map) {
                Map agents = (Map)content;
                for (Map.Entry agentObject : agents.entrySet()) {
                    String agentName = (String)agentObject.getKey();
                    File agentDirectory = new File(buildDirectory, agentName);
                    agentDirectory.mkdirs();
                    File cardFile = new File(agentDirectory, "connection.json");
                    connectionWriter.write(new ScriptingBindings().addBinding("payload", agentObject.getValue(), APPLICATION_JAVA), ServiceManager.apply(), Option.apply((Object)cardFile));
                    ScriptingBindings bindings = new ScriptingBindings().addBinding("exchangeJson", (Object)exchangeJsonFile, APPLICATION_JSON).addBinding("agentName", (Object)agentName, APPLICATION_JAVA).addBinding("agent", agentObject.getValue(), APPLICATION_JAVA);
                    exchangeJsonGenerator.write(bindings, ServiceManager.apply(), Option.apply((Object)new File(agentDirectory, EXCHANGE_JSON)));
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    public void generateExternalMCP(File mainFile, File exchangeJsonFile) throws MojoExecutionException {
        DataWeaveScript externalMCPExtractor = this.dataWeaveScriptingEngine.compile(NameIdentifier.apply((String)"ExternalMCPExtractor", (Option)Option.empty()));
        DataWeaveScript connectionWriter = this.dataWeaveScriptingEngine.compile("input payload output json --- payload");
        DataWeaveScript exchangeJsonGenerator = this.dataWeaveScriptingEngine.compile(NameIdentifier.apply((String)"MCPExchangeJsonGenerator", (Option)Option.empty()));
        try (FileInputStream value = new FileInputStream(mainFile);){
            DataWeaveResult write = externalMCPExtractor.write(new ScriptingBindings().addBinding("payload", (Object)value, APPLICATION_YAML), ServiceManager.apply());
            Object content = write.getContent();
            File buildDirectory = new File(this.project.getBuild().getDirectory(), EXTERNAL_MCP_FOLDER);
            buildDirectory.mkdirs();
            if (content instanceof Map) {
                Map mcpServers = (Map)content;
                for (Map.Entry mcpServer : mcpServers.entrySet()) {
                    String mcpServerName = (String)mcpServer.getKey();
                    File agentDirectory = new File(buildDirectory, mcpServerName);
                    agentDirectory.mkdirs();
                    File cardFile = new File(agentDirectory, "connection.json");
                    connectionWriter.write(new ScriptingBindings().addBinding("payload", mcpServer.getValue(), APPLICATION_JAVA), ServiceManager.apply(), Option.apply((Object)cardFile));
                    ScriptingBindings bindings = new ScriptingBindings().addBinding("exchangeJson", (Object)exchangeJsonFile, APPLICATION_JSON).addBinding("mcpServerName", (Object)mcpServerName, APPLICATION_JAVA);
                    exchangeJsonGenerator.write(bindings, ServiceManager.apply(), Option.apply((Object)new File(agentDirectory, EXCHANGE_JSON)));
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    public void validateMainFile(File mainFile) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Validating " + mainFile.getName() + " against the agentic fabric schema..."));
        JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012, builder -> builder.schemaLoaders(loader -> loader.add((SchemaLoader)new ClassLoaderSchemaLoader())));
        try (InputStream schemaStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("broker_group.json");){
            ObjectMapper yamlMapper;
            JsonNode jsonNode;
            if (schemaStream == null) {
                throw new MojoExecutionException("Could not find broker-group.json on the classpath. Ensure the 'schema' module is a dependency.");
            }
            SchemaValidatorsConfig config = SchemaValidatorsConfig.builder().build();
            JsonSchema jsonSchema = factory.getSchema(schemaStream, config);
            Set errors = jsonSchema.validate(jsonNode = (yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory())).readTree(mainFile));
            if (!errors.isEmpty()) {
                String errorMessages = errors.stream().map(ValidationMessage::toString).collect(Collectors.joining("\n- ", "\n- ", ""));
                throw new MojoExecutionException("The " + mainFile.getName() + " file is not valid according to the schema:" + errorMessages);
            }
            this.getLog().info((CharSequence)"Validation successful.");
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error occurred during schema validation.", (Exception)e);
        }
    }

    private void buildMuleApp() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Building mule app");
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-invoker-plugin"), (String)MojoExecutor.version((String)"3.8.0")), (String)MojoExecutor.goal((String)"run"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"pom"), (String)(String.valueOf(this.outputDirectory) + "/pom.xml")), MojoExecutor.element((String)MojoExecutor.name((String)"streamLogs"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"debug"), (String)String.valueOf(this.getLog().isDebugEnabled())), MojoExecutor.element((String)MojoExecutor.name((String)"goals"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"goal"), (String)"clean"), MojoExecutor.element((String)MojoExecutor.name((String)"goal"), (String)"package")})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
        File buildDirectory = new File(String.valueOf(this.outputDirectory) + File.separator + "target");
        File[] listFiles = buildDirectory.listFiles((dir, name) -> name.endsWith("-mule-application.jar"));
        if (listFiles == null || listFiles.length <= 0) {
            this.getLog().error((CharSequence)"Mule application build failed");
            throw new MojoExecutionException("An error occurred while building the mule application. No mule application was found at :" + buildDirectory.getAbsolutePath());
        }
        File muleApplication = listFiles[0];
        this.helper.attachArtifact(this.project, "jar", "mule-application", muleApplication);
    }

    private void generateMuleApp(File mainFile, File exchangeJsonFile) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Generating agent application...");
        try {
            this.outputDirectory.mkdirs();
            DataWeaveScript muleAppGenerator = this.dataWeaveScriptingEngine.compile(NameIdentifier.apply((String)"MuleAppGenerator", (Option)Option.empty()));
            try (FileInputStream fabricFileStream = new FileInputStream(mainFile);){
                File srcMuleDir = new File(this.outputDirectory, "src" + File.separator + "main" + File.separator + "mule");
                srcMuleDir.mkdirs();
                File outputFile = new File(srcMuleDir, MULE_AGENT_XML);
                ScriptingBindings bindings = new ScriptingBindings().addBinding("payload", (Object)fabricFileStream, APPLICATION_YAML);
                muleAppGenerator.write(bindings, ServiceManager.apply(), Option.apply((Object)outputFile));
            }
            File resourcesMuleDir = new File(this.outputDirectory, "src" + File.separator + "main" + File.separator + "resources");
            resourcesMuleDir.mkdirs();
            DataWeaveScript configYaml = this.dataWeaveScriptingEngine.compile(NameIdentifier.apply((String)"MuleAppConfigGenerator", (Option)Option.empty()));
            try (FileInputStream exchangeJsonStream = new FileInputStream(exchangeJsonFile);){
                File outputFile = new File(resourcesMuleDir, "config.yaml");
                ScriptingBindings bindings = new ScriptingBindings().addBinding("payload", (Object)exchangeJsonStream, APPLICATION_JSON).addBinding("port", (Object)this.port, APPLICATION_JAVA).addBinding("agentGW", (Object)this.agentFabricGwUrl, APPLICATION_JAVA);
                configYaml.write(bindings, ServiceManager.apply(), Option.apply((Object)outputFile));
            }
            this.writeResource(LOG4J_CONFIG, new File(resourcesMuleDir, "log4j2.xml"));
            DataWeaveScript pomGenerator = this.dataWeaveScriptingEngine.compile(NameIdentifier.apply((String)"MuleAppPomGenerator", (Option)Option.empty()));
            try (FileInputStream exchangeJsonStream = new FileInputStream(exchangeJsonFile);){
                File pom = new File(this.outputDirectory, "pom.xml");
                ScriptingBindings bindings = new ScriptingBindings().addBinding("payload", (Object)exchangeJsonStream, APPLICATION_JSON);
                pomGenerator.write(bindings, ServiceManager.apply(), Option.apply((Object)pom));
            }
            this.writeResource(MULE_ARTIFACT_JSON, new File(this.outputDirectory, MULE_ARTIFACT_JSON));
        }
        catch (Exception e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    private void writeResource(String resourcePath, File outputFile) throws Exception {
        try (InputStream resourceAsStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourcePath);){
            assert (resourceAsStream != null);
            try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
                ((OutputStream)outputStream).write(resourceAsStream.readAllBytes());
            }
        }
    }

    private static class ClassLoaderSchemaLoader
    implements SchemaLoader {
        private ClassLoaderSchemaLoader() {
        }

        public InputStreamSource getSchema(AbsoluteIri absoluteIri) {
            String iri = absoluteIri != null ? absoluteIri.toString() : "";
            ClassLoader classLoader = this.getClass().getClassLoader();
            return () -> {
                InputStream result = classLoader.getResourceAsStream(iri);
                if (result == null) {
                    result = classLoader.getResourceAsStream(iri.substring(1));
                }
                return result;
            };
        }
    }
}

