/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.processor;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.building.ModelSource2;
import org.apache.maven.model.io.ModelParseException;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.model.locator.ModelLocator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.mule.maven.exchange.model.ExchangeDependency;
import org.mule.maven.exchange.model.ExchangeModel;
import org.mule.maven.exchange.model.ExchangeModelSerializer;

@Component(role=ModelProcessor.class)
public class ExchangeModelProcessor
implements ModelProcessor {
    private static final Logger LOGGER = Logger.getLogger(ExchangeModelProcessor.class.getName());
    private static final String EXCHANGE_JSON = "exchange.json";
    private static final String TEMPORAL_EXCHANGE_XML = ".exchange.xml";
    public static final String MAVEN_FACADE_SYSTEM_PROPERTY = "-Dexchange.maven.repository.url";
    public static final String MAVEN_FACADE_V2_SYSTEM_PROPERTY = "-Dexchange.maven.v2.repository.url";
    public static final String AGENT_FABRIC_PLUGIN_ARTIFACT = "agent-fabric-plugin";
    public static final String AGENT_FABRIC_GROUP_ID = "com.mulesoft.agents";
    public static final String AGENT_FABRIC_VERSION = "1.0-SNAPSHOT";
    private final ExchangeModelSerializer objectMapper = new ExchangeModelSerializer();
    @Requirement
    private ModelReader modelReader;
    @Requirement
    private ModelLocator modelLocator;

    public void setModelReader(ModelReader modelReader) {
        this.modelReader = modelReader;
    }

    public void setModelLocator(ModelLocator modelLocator) {
        this.modelLocator = modelLocator;
    }

    public File locatePom(File projectDirectory) {
        File pomFile = new File(projectDirectory, EXCHANGE_JSON);
        if (pomFile.exists()) {
            pomFile = new File(pomFile.getParentFile(), TEMPORAL_EXCHANGE_XML);
            try {
                pomFile.createNewFile();
                pomFile.deleteOnExit();
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("error creating temporal `%s` empty file", TEMPORAL_EXCHANGE_XML), e);
            }
        } else {
            pomFile = this.modelLocator.locatePom(projectDirectory);
        }
        return pomFile;
    }

    public Model read(File file, Map<String, ?> map) throws IOException, ModelParseException {
        return this.read(new FileInputStream(file), map);
    }

    public Model read(InputStream inputStream, Map<String, ?> map) throws IOException, ModelParseException {
        return this.read(new InputStreamReader(inputStream, StandardCharsets.UTF_8), map);
    }

    public Model read(Reader reader, Map<String, ?> options) throws IOException, ModelParseException {
        Object source;
        Object v0 = source = options != null ? options.get("org.apache.maven.model.building.source") : null;
        if (source instanceof ModelSource2 && ((ModelSource2)source).getLocation().endsWith(TEMPORAL_EXCHANGE_XML)) {
            String temporalExchangeXml = ((ModelSource2)source).getLocation();
            File temporaryExchangeXml = new File(temporalExchangeXml);
            File exchangeJson = new File(temporaryExchangeXml.getParent(), EXCHANGE_JSON);
            String exchangeJsonLocation = exchangeJson.getAbsolutePath();
            FileInputStream exchangeJsonInputStream = new FileInputStream(exchangeJson);
            Model mavenModel = this.intoModel(exchangeJsonLocation, exchangeJsonInputStream);
            FileModelSource temporalSourceXml = new FileModelSource(exchangeJson);
            options.put("org.apache.maven.model.building.source", temporalSourceXml);
            String data = this.toXmlString(mavenModel);
            FileUtils.fileWrite((File)temporaryExchangeXml, (String)data);
            mavenModel.setPomFile(temporaryExchangeXml);
            return mavenModel;
        }
        return this.modelReader.read(reader, options);
    }

    public Model intoModel(String location, InputStream inputStream) throws IOException {
        ExchangeModel model = this.objectMapper.read(inputStream);
        boolean modified = false;
        if (StringUtils.isBlank((String)model.getAssetId())) {
            model.setAssetId(this.dasherize(model.getName()));
            modified = true;
        }
        if (StringUtils.isBlank((String)model.getVersion())) {
            model.setVersion("1.0.0-SNAPSHOT");
            modified = true;
        }
        if (StringUtils.isBlank((String)model.getGroupId())) {
            throw new RuntimeException("No `groupId` on exchange json or System property `groupId`");
        }
        if (modified) {
            LOGGER.log(Level.WARNING, "[WARNING] exchange.json was modified by the build.");
            this.objectMapper.write(model, new File(location));
        }
        Model mavenModel = this.toMavenModel(model);
        if (Boolean.getBoolean("maven.debug")) {
            LOGGER.log(Level.FINEST, "[DEBUG] Maven Model \n" + this.toXmlString(mavenModel));
        }
        return mavenModel;
    }

    public String toXmlString(Model mavenModel) throws IOException {
        StringWriter stringWriter = new StringWriter();
        new MavenXpp3Writer().write((Writer)stringWriter, mavenModel);
        return stringWriter.toString();
    }

    private Model toMavenModel(ExchangeModel model) {
        Model result = new Model();
        result.setModelVersion("4.0.0");
        result.setArtifactId(model.getAssetId());
        result.setGroupId(model.getGroupId());
        result.setName(model.getName());
        result.setVersion(model.getVersion());
        result.setRepositories((List)Lists.newArrayList((Object[])new Repository[]{this.createExchangeV3Repository(), this.createExchangeV2Repository(), this.createMulesoftReleasesRepository()}));
        List dependencies = model.getDependencies().stream().map(this::toMavenDependency).collect(Collectors.toList());
        result.setDependencies(dependencies);
        Build build = new Build();
        build.setSourceDirectory("${project.basedir}");
        build.addPlugin(this.createPackagerPlugin(model));
        result.setBuild(build);
        return result;
    }

    private String dasherize(String name) {
        return name.toLowerCase().replaceAll(" ", "-");
    }

    private Plugin createPackagerPlugin(ExchangeModel model) {
        Plugin result = new Plugin();
        result.setGroupId(AGENT_FABRIC_GROUP_ID);
        result.setArtifactId(AGENT_FABRIC_PLUGIN_ARTIFACT);
        result.setVersion(AGENT_FABRIC_VERSION);
        PluginExecution generateSources = new PluginExecution();
        generateSources.setId("generate-agent-app");
        generateSources.addGoal("compile-agent-app");
        result.addExecution(generateSources);
        return result;
    }

    private void addSimpleNodeTo(String nodeName, String valueNode, Xpp3Dom configuration) {
        Xpp3Dom goalsNode = new Xpp3Dom(nodeName);
        goalsNode.setValue(valueNode);
        configuration.addChild(goalsNode);
    }

    private Dependency toMavenDependency(ExchangeDependency dep) {
        Dependency result = new Dependency();
        result.setArtifactId(dep.getAssetId());
        result.setGroupId(dep.getGroupId());
        result.setVersion(dep.getVersion());
        this.setOrDefault(dep.getPackaging(), "zip", arg_0 -> ((Dependency)result).setType(arg_0));
        this.setOrDefault(dep.getClassifier(), null, this.setDependencyClassifier(result, result.getType()));
        return result;
    }

    private Consumer<String> setDependencyClassifier(Dependency dependency, String packaging) {
        return classifier -> dependency.setClassifier(this.transformClassifier((String)classifier, packaging));
    }

    private String transformClassifier(String classifier, String packaging) {
        return classifier;
    }

    private void setOrDefault(Object obj, String fallback, Consumer<String> fn) {
        if (obj instanceof String && !((String)obj).isEmpty()) {
            fn.accept((String)obj);
        } else if (fallback != null) {
            fn.accept(fallback);
        }
    }

    private Repository createExchangeV3Repository() {
        String url = System.getProperty(MAVEN_FACADE_SYSTEM_PROPERTY, "https://maven.anypoint.mulesoft.com/api/v3/maven");
        Repository repository = new Repository();
        repository.setId("anypoint-exchange-v3");
        repository.setName("Anypoint Exchange");
        repository.setUrl(url);
        repository.setLayout("default");
        return repository;
    }

    private Repository createExchangeV2Repository() {
        String url = System.getProperty(MAVEN_FACADE_V2_SYSTEM_PROPERTY, "https://maven.anypoint.mulesoft.com/api/v2/maven");
        Repository repository = new Repository();
        repository.setId("anypoint-exchange-v2");
        repository.setName("Anypoint Exchange V2");
        repository.setUrl(url);
        repository.setLayout("default");
        return repository;
    }

    private Repository createMulesoftReleasesRepository() {
        Repository repository = new Repository();
        repository.setId("mulesoft-releases");
        repository.setName("Nexus Repository");
        repository.setUrl("https://repository-master.mulesoft.org/nexus/content/repositories/releases/");
        repository.setLayout("default");
        return repository;
    }
}

