%dw 2.0

input exchangeJson
input mcpServerName


fun toValidAssetId(name: String) = do {
     lower(name)
        replace /\s+/ with "-"
        replace /[^a-z0-9\-]/ with ""
}
output application/json
---
{
  "name": mcpServerName,
  "groupId": exchangeJson.groupId,
  "assetId": toValidAssetId(mcpServerName),
  "version": exchangeJson.version,
  "classifier": "mcp"
}