%dw 2.0

import * from jsonschema!agents_domain
import * from AgentFabricUtils

input payload: Root application/yaml  

ns xsi http://www.w3.org/2001/XMLSchema-instance
ns http http://www.mulesoft.org/schema/mule/http
ns a2a http://www.mulesoft.org/schema/mule/a2a
ns ms_einstein_ai http://www.mulesoft.org/schema/mule/ms-einstein-ai
ns mcp http://www.mulesoft.org/schema/mule/mcp
ns agents_conductor http://www.mulesoft.org/schema/mule/agents-conductor
ns ee http://www.mulesoft.org/schema/mule/ee/core


output application/xml  defaultNamespace="http://www.mulesoft.org/schema/mule/core", writeDeclaredNamespaces="ids:xsi,http,a2a,ms_einstein_ai,mcp,agents_conductor,ee"
---
{
  mule @(xsi#schemaLocation: 
  "http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd\n" ++ 
  "http://www.mulesoft.org/schema/mule/a2a http://www.mulesoft.org/schema/mule/a2a/current/mule-a2a.xsd\n" ++ 
  "http://www.mulesoft.org/schema/mule/http http://www.mulesoft.org/schema/mule/http/current/mule-http.xsd\n" ++ 
  "http://www.mulesoft.org/schema/mule/ms-einstein-ai http://www.mulesoft.org/schema/mule/ms-einstein-ai/current/mule-ms-einstein-ai.xsd\n" ++ 
  "http://www.mulesoft.org/schema/mule/ee/core http://www.mulesoft.org/schema/mule/ee/core/current/mule-ee.xsd\n" ++ 
  "http://www.mulesoft.org/schema/mule/agents-conductor http://www.mulesoft.org/schema/mule/agents-conductor/current/mule-agents-conductor.xsd\n" ++ 
  "http://www.mulesoft.org/schema/mule/mcp http://www.mulesoft.org/schema/mule/mcp/current/mule-mcp.xsd\n" ++
  "http://www.mulesoft.org/schema/mule/oauth http://www.mulesoft.org/schema/mule/oauth/current/mule-oauth.xsd"): {
      (createConfigurationElement()),
      (createHttpListenerConfig()),
      (createAgentListenerConfig(payload.agents)),
      (createConductorConfig(payload.agents)),
      (createAgentClientConfig(payload.agents)),
      (createExternalAgentClientConfig(payload."services"."external-agents")),
      (createMCPClientConfig(payload."services"."mcp-servers")),
      (createLLMProvidersConfig(payload."services"."llm-providers")),
      (createAgents(payload.agents, payload."services"."llm-providers"))      
    }
}
