%dw 2.0

input exchangeJson
input agentName
input agent

fun toValidAssetId(name: String) = do {
     lower(name)
        replace /\s+/ with "-"
        replace /[^a-z0-9\-]/ with ""
}
output application/json
---
{
  "main": "$(agentName)-card.json",
  "name": agentName,
  "groupId": exchangeJson.groupId,
  "assetId": toValidAssetId(agentName),
  "version": exchangeJson.version,
  "classifier": "a2a",
  "tags": agent.skills flatMap ((item, index) -> item.tags) onNull (() -> [])
}