%dw 2.0

import * from jsonschema!broker_group
import * from AgentFabricUtils

input payload: Root application/yaml  

ns xsi http://www.w3.org/2001/XMLSchema-instance
ns http http://www.mulesoft.org/schema/mule/http
ns a2a http://www.mulesoft.org/schema/mule/a2a
ns ms_einstein_ai http://www.mulesoft.org/schema/mule/ms-einstein-ai
ns mcp http://www.mulesoft.org/schema/mule/mcp
ns agents_broker http://www.mulesoft.org/schema/mule/agents-broker
ns ee http://www.mulesoft.org/schema/mule/ee/core


output application/xml  defaultNamespace="http://www.mulesoft.org/schema/mule/core", writeDeclaredNamespaces="ids:xsi,http,a2a,ms_einstein_ai,mcp,agents_broker,ee"
---
{
  mule @(xsi#schemaLocation: 
  "http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd\n" ++ 
  "http://www.mulesoft.org/schema/mule/a2a http://www.mulesoft.org/schema/mule/a2a/current/mule-a2a.xsd\n" ++ 
  "http://www.mulesoft.org/schema/mule/http http://www.mulesoft.org/schema/mule/http/current/mule-http.xsd\n" ++ 
  "http://www.mulesoft.org/schema/mule/ms-einstein-ai http://www.mulesoft.org/schema/mule/ms-einstein-ai/current/mule-ms-einstein-ai.xsd\n" ++ 
  "http://www.mulesoft.org/schema/mule/ee/core http://www.mulesoft.org/schema/mule/ee/core/current/mule-ee.xsd\n" ++ 
  "http://www.mulesoft.org/schema/mule/agents-broker http://www.mulesoft.org/schema/mule/agents-broker/current/mule-agents-broker.xsd\n" ++
  "http://www.mulesoft.org/schema/mule/mcp http://www.mulesoft.org/schema/mule/mcp/current/mule-mcp.xsd\n" ++
  "http://www.mulesoft.org/schema/mule/oauth http://www.mulesoft.org/schema/mule/oauth/current/mule-oauth.xsd"): {
      (createConfigurationElement()),
      (createHttpListenerConfig()),
      (createAgentListenerConfig(payload.brokers)),
      (createConductorConfig(payload.brokers, payload."services"."llm-providers")),
      (createAgentClientConfig(payload.brokers)),
      (createExternalAgentClientConfig(payload."services"."external-agents")),
      (createMCPClientConfig(payload."services"."mcp-servers")),
      (createLLMProvidersConfig(payload."services"."llm-providers")),
      (createAgents(payload.brokers, payload."services"."llm-providers"))
    }
}
