/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.annotation;

import com.networknt.schema.JsonNodePath;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.annotation.JsonNodeAnnotation;
import java.util.function.Predicate;

public class JsonNodeAnnotationPredicate
implements Predicate<JsonNodeAnnotation> {
    final Predicate<JsonNodePath> instanceLocationPredicate;
    final Predicate<JsonNodePath> evaluationPathPredicate;
    final Predicate<SchemaLocation> schemaLocationPredicate;
    final Predicate<String> keywordPredicate;
    final Predicate<Object> valuePredicate;

    protected JsonNodeAnnotationPredicate(Predicate<JsonNodePath> instanceLocationPredicate, Predicate<JsonNodePath> evaluationPathPredicate, Predicate<SchemaLocation> schemaLocationPredicate, Predicate<String> keywordPredicate, Predicate<Object> valuePredicate) {
        this.instanceLocationPredicate = instanceLocationPredicate;
        this.evaluationPathPredicate = evaluationPathPredicate;
        this.schemaLocationPredicate = schemaLocationPredicate;
        this.keywordPredicate = keywordPredicate;
        this.valuePredicate = valuePredicate;
    }

    @Override
    public boolean test(JsonNodeAnnotation t2) {
        return !(this.valuePredicate != null && !this.valuePredicate.test(t2.getValue()) || this.keywordPredicate != null && !this.keywordPredicate.test(t2.getKeyword()) || this.instanceLocationPredicate != null && !this.instanceLocationPredicate.test(t2.getInstanceLocation()) || this.evaluationPathPredicate != null && !this.evaluationPathPredicate.test(t2.getEvaluationPath()) || this.schemaLocationPredicate != null && !this.schemaLocationPredicate.test(t2.getSchemaLocation()));
    }

    public Predicate<JsonNodePath> getInstanceLocationPredicate() {
        return this.instanceLocationPredicate;
    }

    public Predicate<JsonNodePath> getEvaluationPathPredicate() {
        return this.evaluationPathPredicate;
    }

    public Predicate<SchemaLocation> getSchemaLocationPredicate() {
        return this.schemaLocationPredicate;
    }

    public Predicate<String> getKeywordPredicate() {
        return this.keywordPredicate;
    }

    public Predicate<Object> getValuePredicate() {
        return this.valuePredicate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        Predicate<JsonNodePath> instanceLocationPredicate;
        Predicate<JsonNodePath> evaluationPathPredicate;
        Predicate<SchemaLocation> schemaLocationPredicate;
        Predicate<String> keywordPredicate;
        Predicate<Object> valuePredicate;

        public Builder instanceLocation(Predicate<JsonNodePath> instanceLocationPredicate) {
            this.instanceLocationPredicate = instanceLocationPredicate;
            return this;
        }

        public Builder evaluationPath(Predicate<JsonNodePath> evaluationPathPredicate) {
            this.evaluationPathPredicate = evaluationPathPredicate;
            return this;
        }

        public Builder schema(Predicate<SchemaLocation> schemaLocationPredicate) {
            this.schemaLocationPredicate = schemaLocationPredicate;
            return this;
        }

        public Builder keyword(Predicate<String> keywordPredicate) {
            this.keywordPredicate = keywordPredicate;
            return this;
        }

        public Builder value(Predicate<Object> valuePredicate) {
            this.valuePredicate = valuePredicate;
            return this;
        }

        public JsonNodeAnnotationPredicate build() {
            return new JsonNodeAnnotationPredicate(this.instanceLocationPredicate, this.evaluationPathPredicate, this.schemaLocationPredicate, this.keywordPredicate, this.valuePredicate);
        }
    }
}

