/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.core.xml.utils;

import org.mule.weave.v2.model.structure.BufferedCharSequence;
import org.mule.weave.v2.model.structure.StreamSourceBufferedCharSequence$;
import org.mule.weave.v2.module.core.json.reader.indexed.UnescapeChars;
import org.mule.weave.v2.module.core.xml.utils.UnescapedXmlBufferedCharSequenceReader$;
import scala.collection.mutable.StringBuilder;

public final class XmlEscapeUtils$ {
    public static XmlEscapeUtils$ MODULE$;

    static {
        new XmlEscapeUtils$();
    }

    public CharSequence unescapeXml(String input) {
        return this.unescapeCharsUntilSize(0, input.length(), input).unescaped();
    }

    public CharSequence unescapeXml(CharSequence input) {
        CharSequence charSequence;
        CharSequence charSequence2 = input;
        if (charSequence2 instanceof String) {
            String string = (String)charSequence2;
            charSequence = this.unescapeCharsUntilSize(0, string.length(), string).unescaped();
        } else if (charSequence2 instanceof BufferedCharSequence) {
            BufferedCharSequence bufferedCharSequence = (BufferedCharSequence)charSequence2;
            charSequence = StreamSourceBufferedCharSequence$.MODULE$.apply(UnescapedXmlBufferedCharSequenceReader$.MODULE$.apply(bufferedCharSequence));
        } else {
            String source = ((Object)input).toString();
            charSequence = this.unescapeCharsUntilSize(0, source.length(), source).unescaped();
        }
        String unescaped = charSequence;
        return unescaped;
    }

    public UnescapeChars unescapeCharsUntilSize(int offset, int length, CharSequence source) {
        int index = offset;
        StringBuilder builder = new StringBuilder();
        for (int charsCounter = 0; charsCounter < length; ++charsCounter) {
            try {
                char char2;
                char c = source.charAt(index);
                int consumed = 0;
                if (c == '&') {
                    char char22;
                    consumed = this.unescapeEntity(source, index, builder);
                    if (consumed != 0) {
                        index += consumed;
                        continue;
                    }
                    builder.append(c);
                    if (!Character.isHighSurrogate(c) || !Character.isLowSurrogate(char22 = source.charAt(++index))) continue;
                    builder.append(char22);
                    ++index;
                    continue;
                }
                builder.append(c);
                if (!Character.isHighSurrogate(c) || !Character.isLowSurrogate(char2 = source.charAt(++index))) continue;
                builder.append(char2);
                ++index;
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return new UnescapeChars(index - 1, builder.toString());
            }
        }
        return new UnescapeChars(index - 1, builder.toString());
    }

    private int unescapeEntity(CharSequence source, int index, StringBuilder builder) {
        int consumed;
        block0: {
            consumed = this.tryToUnescapeBasicEntity(source, index, builder);
            if (consumed != 0) break block0;
            consumed = this.tryToUnescapedNumericEntity(source, index, builder);
        }
        return consumed;
    }

    private int tryToUnescapeBasicEntity(CharSequence source, int index, StringBuilder builder) {
        int consumed = 0;
        try {
            char[] chars = new char[5];
            chars[0] = source.charAt(index + 1);
            chars[1] = source.charAt(index + 2);
            chars[2] = source.charAt(index + 3);
            if (chars[0] == 'l' && chars[1] == 't' && chars[2] == ';') {
                builder.append("<");
                consumed = 4;
            } else if (chars[0] == 'g' && chars[1] == 't' && chars[2] == ';') {
                builder.append(">");
                consumed = 4;
            } else {
                chars[3] = source.charAt(index + 4);
                if (chars[0] == 'a' && chars[1] == 'm' && chars[2] == 'p' && chars[3] == ';') {
                    builder.append("&");
                    consumed = 5;
                } else {
                    chars[4] = source.charAt(index + 5);
                    if (chars[0] == 'a' && chars[1] == 'p' && chars[2] == 'o' && chars[3] == 's' && chars[4] == ';') {
                        builder.append("'");
                        consumed = 6;
                    } else if (chars[0] == 'q' && chars[1] == 'u' && chars[2] == 'o' && chars[3] == 't' && chars[4] == ';') {
                        builder.append("\"");
                        consumed = 6;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return consumed;
    }

    private int tryToUnescapedNumericEntity(CharSequence source, int index, StringBuilder builder) {
        int consumed;
        block8: {
            consumed = 0;
            try {
                char semiColon;
                if (source.charAt(index + 1) != '#') break block8;
                int start = index + 2;
                boolean isHex = false;
                char firstChar = source.charAt(start);
                if (firstChar == 'x' || firstChar == 'X') {
                    ++start;
                    isHex = true;
                }
                int end = start;
                StringBuilder entityBuffer = new StringBuilder();
                char nextChar = source.charAt(end);
                while (nextChar >= '0' && nextChar <= '9' || nextChar >= 'a' && nextChar <= 'f' || nextChar >= 'A' && nextChar <= 'F') {
                    entityBuffer.append(nextChar);
                    nextChar = source.charAt(++end);
                }
                if (!entityBuffer.nonEmpty() || (semiColon = source.charAt(end)) != ';') break block8;
                int entityValue = 0;
                try {
                    StringBuilder stringBuilder;
                    entityValue = isHex ? Integer.parseInt(entityBuffer.toString(), 16) : Integer.parseInt(entityBuffer.toString(), 10);
                    if (entityValue > 65535) {
                        char[] chars = Character.toChars(entityValue);
                        builder.append(chars[0]);
                        stringBuilder = builder.append(chars[1]);
                    } else {
                        stringBuilder = builder.append((char)entityValue);
                    }
                    consumed = 2 + end - start + (isHex ? 1 : 0) + 1;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        return consumed;
    }

    private XmlEscapeUtils$() {
        MODULE$ = this;
    }
}

