/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.ts;

import java.io.Serializable;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.LiteralValueAstNode;
import org.mule.weave.v2.parser.ast.structure.ArrayNode;
import org.mule.weave.v2.parser.ast.structure.KeyNode;
import org.mule.weave.v2.parser.ast.structure.KeyValuePairNode;
import org.mule.weave.v2.parser.ast.structure.ObjectNode;
import org.mule.weave.v2.parser.ast.structure.StringNode;
import org.mule.weave.v2.parser.ast.structure.schema.SchemaNode;
import org.mule.weave.v2.parser.ast.structure.schema.SchemaPropertyNode;
import org.mule.weave.v2.parser.ast.variables.VariableReferenceNode;
import org.mule.weave.v2.scope.Reference;
import org.mule.weave.v2.scope.ScopesNavigator;
import org.mule.weave.v2.ts.ArrayMetadataValue;
import org.mule.weave.v2.ts.KeyValuePairMetadataValue;
import org.mule.weave.v2.ts.LiteralMetadataValue;
import org.mule.weave.v2.ts.Metadata;
import org.mule.weave.v2.ts.MetadataValue;
import org.mule.weave.v2.ts.ObjectMetadataValue;
import org.mule.weave.v2.ts.SystemWeaveTypes$;
import org.mule.weave.v2.ts.UnknownMetadataValue;
import org.mule.weave.v2.ts.VariableReferenceMetadataValue;
import org.mule.weave.v2.ts.WeaveType;
import org.mule.weave.v2.ts.WeaveTypeMetadataAnnotator$;
import org.mule.weave.v2.ts.WeaveTypeReferenceResolver;
import org.mule.weave.v2.utils.SchemaNodeOrigin$;
import org.mule.weave.v2.utils.StringEscapeHelper$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcC$sp;

@ScalaSignature(bytes="\u0006\u0001\t4A\u0001D\u0007\u00011!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0011!\u0001\u0004A!A!\u0002\u0013\t\u0004\"\u0002\u001b\u0001\t\u0003)\u0004\"\u0002\u001e\u0001\t\u0003Y\u0004\"B \u0001\t\u0013\u0001\u0005\"\u0002&\u0001\t\u0013Yu!B-\u000e\u0011\u0003Qf!\u0002\u0007\u000e\u0011\u0003Y\u0006\"\u0002\u001b\n\t\u0003a\u0006\"B/\n\t\u0003q&AG,fCZ,G+\u001f9f\u001b\u0016$\u0018\rZ1uC\u0006sgn\u001c;bi>\u0014(B\u0001\b\u0010\u0003\t!8O\u0003\u0002\u0011#\u0005\u0011aO\r\u0006\u0003%M\tQa^3bm\u0016T!\u0001F\u000b\u0002\t5,H.\u001a\u0006\u0002-\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0007\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\rM\u001c\u0007.Z7b!\t\t\u0013&D\u0001#\u0015\ty2E\u0003\u0002%K\u0005I1\u000f\u001e:vGR,(/\u001a\u0006\u0003M\u001d\n1!Y:u\u0015\tAs\"\u0001\u0004qCJ\u001cXM]\u0005\u0003U\t\u0012!bU2iK6\fgj\u001c3f\u0003\u0019\u0011Xm];miB\u0011QFL\u0007\u0002\u001b%\u0011q&\u0004\u0002\n/\u0016\fg/\u001a+za\u0016\fQ\u0003^=qKJ+g-\u001a:f]\u000e,'+Z:pYZ,'\u000f\u0005\u0002.e%\u00111'\u0004\u0002\u001b/\u0016\fg/\u001a+za\u0016\u0014VMZ3sK:\u001cWMU3t_24XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\tY:\u0004(\u000f\t\u0003[\u0001AQa\b\u0003A\u0002\u0001BQa\u000b\u0003A\u00021BQ\u0001\r\u0003A\u0002E\n\u0001\"\u00198o_R\fG/\u001a\u000b\u0002yA\u0011!$P\u0005\u0003}m\u0011A!\u00168ji\u0006)r-\u001a8fe\u0006$X-T3uC\u0012\fG/\u0019,bYV,GCA!E!\ti#)\u0003\u0002D\u001b\tiQ*\u001a;bI\u0006$\u0018MV1mk\u0016DQ!\u0012\u0004A\u0002\u0019\u000bAA\\8eKB\u0011q\tS\u0007\u0002K%\u0011\u0011*\n\u0002\b\u0003N$hj\u001c3f\u0003)9W\r^&fs:\u000bW.\u001a\u000b\u0003\u0019^\u0003\"!\u0014+\u000f\u00059\u0013\u0006CA(\u001c\u001b\u0005\u0001&BA)\u0018\u0003\u0019a$o\\8u}%\u00111kG\u0001\u0007!J,G-\u001a4\n\u0005U3&AB*ue&twM\u0003\u0002T7!)\u0001l\u0002a\u0001\r\u0006\u00191.Z=\u00025]+\u0017M^3UsB,W*\u001a;bI\u0006$\u0018-\u00118o_R\fGo\u001c:\u0011\u00055J1CA\u0005\u001a)\u0005Q\u0016!B1qa2LH\u0003\u0002\u001c`A\u0006DQaH\u0006A\u0002\u0001BQaK\u0006A\u00021BQ\u0001M\u0006A\u0002E\u0002")
public class WeaveTypeMetadataAnnotator {
    private final SchemaNode schema;
    private final WeaveType result;
    private final WeaveTypeReferenceResolver typeReferenceResolver;

    public static WeaveTypeMetadataAnnotator apply(SchemaNode schemaNode, WeaveType weaveType, WeaveTypeReferenceResolver weaveTypeReferenceResolver) {
        return WeaveTypeMetadataAnnotator$.MODULE$.apply(schemaNode, weaveType, weaveTypeReferenceResolver);
    }

    public void annotate() {
        if (this.schema.properties().isEmpty()) {
            this.result.markWithEmptyMetadata();
            return;
        }
        this.schema.properties().foreach((Function1<SchemaPropertyNode, Object> & Serializable & scala.Serializable)property -> {
            AstNode astNode = property.name();
            if (astNode instanceof StringNode) {
                StringNode stringNode = (StringNode)astNode;
                String key = stringNode.value();
                MetadataValue metadataValue = this.generateMetadataValue(property.value());
                return $this.result.withMetadata(new Metadata(key, metadataValue, SchemaNodeOrigin$.MODULE$.apply($this.schema)));
            }
            return BoxedUnit.UNIT;
        });
    }

    private MetadataValue generateMetadataValue(AstNode node2) {
        AstNode astNode = node2;
        if (astNode instanceof StringNode) {
            StringNode stringNode = (StringNode)astNode;
            String value = StringEscapeHelper$.MODULE$.unescapeString(stringNode.literalValue(), BoxesRunTime.unboxToChar(stringNode.quotedBy().getOrElse((JFunction0$mcC$sp & scala.Serializable)() -> '\"')), stringNode.location());
            WeaveType weaveType = (WeaveType)SystemWeaveTypes$.MODULE$.getLiteralTypeByNode(stringNode.getClass()).orNull(Predef$.MODULE$.$conforms());
            return new LiteralMetadataValue(value, weaveType, stringNode.location());
        }
        if (astNode instanceof LiteralValueAstNode) {
            LiteralValueAstNode literalValueAstNode = (LiteralValueAstNode)astNode;
            String value = literalValueAstNode.literalValue();
            WeaveType weaveType = (WeaveType)SystemWeaveTypes$.MODULE$.getLiteralTypeByNode(literalValueAstNode.getClass()).orNull(Predef$.MODULE$.$conforms());
            return new LiteralMetadataValue(value, weaveType, literalValueAstNode.location());
        }
        if (astNode instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)astNode;
            Seq<MetadataValue> elements = arrayNode.elements().map((Function1<AstNode, MetadataValue> & Serializable & scala.Serializable)node -> this.generateMetadataValue((AstNode)node), Seq$.MODULE$.canBuildFrom());
            return new ArrayMetadataValue(elements, arrayNode.location());
        }
        if (astNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)astNode;
            Seq<KeyValuePairMetadataValue> properties = objectNode.elements().map((Function1<AstNode, KeyValuePairMetadataValue> & Serializable & scala.Serializable)element -> {
                MetadataValue generate = this.generateMetadataValue((AstNode)element);
                return (KeyValuePairMetadataValue)generate;
            }, Seq$.MODULE$.canBuildFrom());
            return new ObjectMetadataValue(properties, objectNode.location());
        }
        if (astNode instanceof KeyValuePairNode) {
            KeyValuePairNode keyValuePairNode = (KeyValuePairNode)astNode;
            String keyName = this.getKeyName(keyValuePairNode.key());
            MetadataValue value = this.generateMetadataValue(keyValuePairNode.value());
            return new KeyValuePairMetadataValue(keyName, value, keyValuePairNode.location());
        }
        if (astNode instanceof VariableReferenceNode) {
            VariableReferenceNode variableReferenceNode = (VariableReferenceNode)astNode;
            Option maybeResolved = this.typeReferenceResolver.scopesNavigator().flatMap((Function1<ScopesNavigator, Option> & Serializable & scala.Serializable)x$1 -> x$1.resolveVariable(variableReferenceNode.variable()));
            if (maybeResolved.isDefined()) {
                return new VariableReferenceMetadataValue(((Reference)maybeResolved.get()).fqnReferenceName().fullQualifiedName(), variableReferenceNode.location());
            }
            return new UnknownMetadataValue(variableReferenceNode.location());
        }
        return new UnknownMetadataValue(astNode.location());
    }

    private String getKeyName(AstNode key) {
        KeyNode keyNode;
        AstNode astNode;
        AstNode astNode2 = key;
        if (astNode2 instanceof KeyNode && (astNode = (keyNode = (KeyNode)astNode2).keyName()) instanceof StringNode) {
            StringNode stringNode = (StringNode)astNode;
            String keyValue = stringNode.value();
            return keyValue;
        }
        return "unknown";
    }

    public WeaveTypeMetadataAnnotator(SchemaNode schema, WeaveType result, WeaveTypeReferenceResolver typeReferenceResolver) {
        this.schema = schema;
        this.result = result;
        this.typeReferenceResolver = typeReferenceResolver;
    }
}

