%dw 2.0
ns xsi http://www.w3.org/2001/XMLSchema-instance
output application/xml  defaultNamespace="http://maven.apache.org/POM/4.0.0"
input payload
---
{
  project @(xsi#schemaLocation: "http://maven.apache.org/POM/4.0.0 https://maven.apache.org/xsd/maven-4.0.0.xsd"): {
    modelVersion: "4.0.0",
    groupId: payload.groupId,
    artifactId: payload.assetId,
    version: payload.version,
    packaging: "mule-application",
    name: payload.assetId,
    properties: {
      "project.build.sourceEncoding": "UTF-8",
      "project.reporting.outputEncoding": "UTF-8",
      "app.runtime": "4.9.7",
      "mule.maven.plugin.version": "4.3.0",
      "mule-agent-router-module.version": "0.4.1",
      "mule-mcp-connector.version": "1.2.1",
      "mule-oauth-module.version": "1.1.24",
      "mule4-a2a-connector.version": "0.4.0-BETA",
      "mule-sockets-connector.version": "1.2.6",
      "mule-http-connector.version": "1.10.4"
    },
    build: {
      plugins: {
        plugin: {
          groupId: "org.apache.maven.plugins",
          artifactId: "maven-clean-plugin",
          version: "3.2.0"
        },
        plugin: {
          groupId: "org.mule.tools.maven",
          artifactId: "mule-maven-plugin",
          version: "\${mule.maven.plugin.version}",
          extensions: "true"
        }
      }
    },
    dependencies: {
      dependency: {
        groupId: "org.mule.connectors",
        artifactId: "mule-http-connector",
        version: "\${mule-http-connector.version}",
        classifier: "mule-plugin"
      },
      dependency: {
        groupId: "org.mule.connectors",
        artifactId: "mule-sockets-connector",
        version: "\${mule-sockets-connector.version}",
        classifier: "mule-plugin"
      },
      dependency: {
        groupId: "com.mulesoft.connectors",
        artifactId: "mule4-a2a-connector",
        version: "\${mule4-a2a-connector.version}",
        classifier: "mule-plugin"
      },
      dependency: {
        groupId: "com.mulesoft.modules",
        artifactId: "mule-agent-router-module",
        version: "\${mule-agent-router-module.version}",
        classifier: "mule-plugin"
      },
      dependency: {
        groupId: "com.mulesoft.connectors",
        artifactId: "mule-mcp-connector",
        version: "\${mule-mcp-connector.version}",
        classifier: "mule-plugin"
      },
      dependency: {
        groupId: "org.mule.modules",
        artifactId: "mule-oauth-module",
        version: "\${mule-oauth-module.version}",
        classifier: "mule-plugin"
      }
    },
    repositories: {
      repository: {
        id: "anypoint-exchange-v3",
        name: "Anypoint Exchange",
        url: "https://maven.anypoint.mulesoft.com/api/v3/maven",
        layout: "default"
      },
      repository: {
        id: "mulesoft-releases",
        name: "MuleSoft Releases Repository",
        url: "https://repository.mulesoft.org/releases/",
        layout: "default"
      },
      repository: {
        id: "mulesoft-snapshots",
        name: "MuleSoft Snapshots Repository",
        url: "https://repository.mulesoft.org/snapshots/",
        layout: "default"
      }
    },
    pluginRepositories: {
      pluginRepository: {
        id: "mulesoft-releases",
        name: "MuleSoft Releases Repository",
        layout: "default",
        url: "https://repository.mulesoft.org/releases/",
        snapshots: {
          enabled: "false"
        }
      }
    }
  }
}
