/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.commons.java.writer.converter;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.values.math.Number;
import org.mule.weave.v2.module.commons.java.writer.converter.DataConverter;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00153Aa\u0001\u0003\u0001/!)Q\u0005\u0001C\u0001M!)\u0001\u0006\u0001C!S\t\u0011b\t\\8bi\u0012\u000bG/Y\"p]Z,'\u000f^3s\u0015\t)a!A\u0005d_:4XM\u001d;fe*\u0011q\u0001C\u0001\u0007oJLG/\u001a:\u000b\u0005%Q\u0011\u0001\u00026bm\u0006T!a\u0003\u0007\u0002\u000f\r|W.\\8og*\u0011QBD\u0001\u0007[>$W\u000f\\3\u000b\u0005=\u0001\u0012A\u0001<3\u0015\t\t\"#A\u0003xK\u00064XM\u0003\u0002\u0014)\u0005!Q.\u001e7f\u0015\u0005)\u0012aA8sO\u000e\u00011c\u0001\u0001\u0019=A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\u00042a\b\u0011#\u001b\u0005!\u0011BA\u0011\u0005\u00055!\u0015\r^1D_:4XM\u001d;feB\u0011\u0011dI\u0005\u0003Ii\u0011QA\u00127pCR\fa\u0001P5oSRtD#A\u0014\u0011\u0005}\u0001\u0011aB2p]Z,'\u000f\u001e\u000b\u0004UYZDCA\u0016/!\rIBFI\u0005\u0003[i\u0011aa\u00149uS>t\u0007\"B\u0018\u0003\u0001\b\u0001\u0014aA2uqB\u0011\u0011\u0007N\u0007\u0002e)\u00111GD\u0001\u0006[>$W\r\\\u0005\u0003kI\u0012\u0011#\u0012<bYV\fG/[8o\u0007>tG/\u001a=u\u0011\u00159$\u00011\u00019\u0003\u0019\u0019x.\u001e:dKB\u0011\u0011$O\u0005\u0003ui\u00111!\u00118z\u0011\u0015a$\u00011\u0001>\u0003\u0019\u00198\r[3nCB\u0019\u0011\u0004\f \u0011\u0005}\u001aU\"\u0001!\u000b\u0005q\n%B\u0001\"3\u0003%\u0019HO];diV\u0014X-\u0003\u0002E\u0001\n11k\u00195f[\u0006\u0004")
public class FloatDataConverter
implements DataConverter<Object> {
    @Override
    public Option<String> format(Map<String, Object> arguments) {
        return DataConverter.format$(this, arguments);
    }

    @Override
    public Option<String> separator(Map<String, Object> arguments) {
        return DataConverter.separator$(this, arguments);
    }

    @Override
    public Option<String> encoding(Map<String, Object> arguments) {
        return DataConverter.encoding$(this, arguments);
    }

    @Override
    public Option<Object> convert(Object source, Option<Schema> schema, EvaluationContext ctx) {
        Object object = source;
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong(object);
            return Option$.MODULE$.apply(BoxesRunTime.boxToFloat(l));
        }
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt(object);
            return Option$.MODULE$.apply(BoxesRunTime.boxToFloat(n));
        }
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(object);
            return Option$.MODULE$.apply(BoxesRunTime.boxToFloat((float)d));
        }
        if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat(object);
            return Option$.MODULE$.apply(BoxesRunTime.boxToFloat(f));
        }
        if (object instanceof Short) {
            short s2 = BoxesRunTime.unboxToShort(object);
            return Option$.MODULE$.apply(BoxesRunTime.boxToFloat(s2));
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return Option$.MODULE$.apply(BoxesRunTime.boxToFloat(number.toFloat()));
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            return Option$.MODULE$.apply(BoxesRunTime.boxToFloat(bigDecimal.floatValue()));
        }
        if (object instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)object;
            return Option$.MODULE$.apply(BoxesRunTime.boxToFloat(bigInteger.floatValue()));
        }
        if (object instanceof String) {
            String string = (String)object;
            return Option$.MODULE$.apply(BoxesRunTime.boxToFloat(new StringOps(Predef$.MODULE$.augmentString(string)).toFloat()));
        }
        return None$.MODULE$;
    }

    public FloatDataConverter() {
        DataConverter.$init$(this);
    }
}

