/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time.token;

import com.ethlo.time.DateTime;
import com.ethlo.time.DateTimeParser;
import com.ethlo.time.Field;
import com.ethlo.time.TimezoneOffset;
import com.ethlo.time.internal.token.FractionsToken;
import com.ethlo.time.token.DateTimeToken;
import java.text.ParsePosition;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.HashSet;

public class ConfigurableDateTimeParser
implements DateTimeParser {
    private final DateTimeToken[] tokens;

    private ConfigurableDateTimeParser(DateTimeToken ... tokens) {
        HashSet fieldsSeen = new HashSet();
        Arrays.asList(tokens).forEach(t2 -> {
            if (t2.getField() != null && !fieldsSeen.add(t2.getField())) {
                throw new IllegalArgumentException("Duplicate field " + (Object)((Object)t2.getField()) + " in list of tokens: " + Arrays.toString(tokens));
            }
        });
        this.tokens = tokens;
    }

    public static DateTimeParser of(DateTimeToken ... tokens) {
        return new ConfigurableDateTimeParser(tokens);
    }

    @Override
    public DateTime parse(String text, ParsePosition parsePosition) {
        try {
            return this.doParse(text, parsePosition);
        }
        catch (DateTimeParseException exc) {
            parsePosition.setIndex(exc.getErrorIndex());
            parsePosition.setErrorIndex(exc.getErrorIndex());
            throw exc;
        }
    }

    private DateTime doParse(String text, ParsePosition parsePosition) {
        int fractionsLength = 0;
        int highestOrdinal = Field.YEAR.ordinal();
        int[] values = new int[]{0, 1, 1, 0, 0, 0, 0, -1};
        for (DateTimeToken token : this.tokens) {
            int index = parsePosition.getIndex();
            int value = token.read(text, parsePosition);
            Field field2 = token.getField();
            if (field2 == null) continue;
            int ordinal = field2.ordinal();
            values[ordinal] = value;
            highestOrdinal = Math.max(ordinal, highestOrdinal);
            if (!(token instanceof FractionsToken)) continue;
            fractionsLength = parsePosition.getIndex() - index;
            values[ordinal] = this.scale(value, fractionsLength);
        }
        return new DateTime(Field.values()[Math.min(highestOrdinal, Field.NANO.ordinal())], values[Field.YEAR.ordinal()], values[Field.MONTH.ordinal()], values[Field.DAY.ordinal()], values[Field.HOUR.ordinal()], values[Field.MINUTE.ordinal()], values[Field.SECOND.ordinal()], values[Field.NANO.ordinal()], values[Field.ZONE_OFFSET.ordinal()] != -1 ? TimezoneOffset.ofTotalSeconds(values[Field.ZONE_OFFSET.ordinal()]) : null, fractionsLength);
    }

    private int scale(int value, int length) {
        for (int pos = length; pos < 9; ++pos) {
            value *= 10;
        }
        return value;
    }
}

