%dw 2.0

import fail from dw::Runtime
import * from dw::io::file::FileSystem
import * from jsonschema!agent_network
import * from AgentFabricUtils

input payload: Root application/yaml
input exchange: Exchange application/json
input env: { lowerEnv: Boolean, modulesPath: String }


ns xsi http://www.w3.org/2001/XMLSchema-instance
ns http http://www.mulesoft.org/schema/mule/http
ns a2a http://www.mulesoft.org/schema/mule/a2a
ns ms_einstein_ai http://www.mulesoft.org/schema/mule/ms-einstein-ai
ns mcp http://www.mulesoft.org/schema/mule/mcp
ns agents_broker http://www.mulesoft.org/schema/mule/agents-broker
ns ee http://www.mulesoft.org/schema/mule/ee/core


output application/xml defaultNamespace="http://www.mulesoft.org/schema/mule/core", writeDeclaredNamespaces="ids:xsi,http,a2a,ms_einstein_ai,mcp,agents_broker,ee"

fun mcpResolver(namespace: String, name: String): MCPServer | Null = do {
    if(namespace == exchange.groupId and payload.mcpServers[name]?) 
      payload.mcpServers[name].metadata
    else do {      
      var gav = resolveReference(namespace, name, exchange)
      ---
      if(gav != null) do {
          var asset = path(env.modulesPath, gav.groupId, gav.assetId, gav.version)
          var mcp = path(asset, "mcp-metadata.json")
          ---
          if(exists(asset) and exists(mcp))
            readUrl(toUrl(mcp), "application/json") as MCPServer
          else if(exists(asset))
            null
          else 
            fail("Unable to locate mcp asset for: $(write(gav))")
        }
      else 
        fail("Unable to resolve mcp reference for: $(write(gav))")
    }
  }
---
{
  mule @(xsi#schemaLocation: 
      "http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd\n" ++ 
          "http://www.mulesoft.org/schema/mule/a2a http://www.mulesoft.org/schema/mule/a2a/current/mule-a2a.xsd\n" ++ 
          "http://www.mulesoft.org/schema/mule/http http://www.mulesoft.org/schema/mule/http/current/mule-http.xsd\n" ++ 
          "http://www.mulesoft.org/schema/mule/ms-einstein-ai http://www.mulesoft.org/schema/mule/ms-einstein-ai/current/mule-ms-einstein-ai.xsd\n" ++ 
          "http://www.mulesoft.org/schema/mule/ee/core http://www.mulesoft.org/schema/mule/ee/core/current/mule-ee.xsd\n" ++ 
          "http://www.mulesoft.org/schema/mule/agents-broker http://www.mulesoft.org/schema/mule/agents-broker/current/mule-agents-broker.xsd\n" ++
          "http://www.mulesoft.org/schema/mule/mcp http://www.mulesoft.org/schema/mule/mcp/current/mule-mcp.xsd\n" ++
          "http://www.mulesoft.org/schema/mule/oauth http://www.mulesoft.org/schema/mule/oauth/current/mule-oauth.xsd"): {
      (createConfigurationElement()),
      (createHttpListenerConfig()),
      (createAgentListenerConfig(payload.brokers!)),
      (createConductorConfig(payload.brokers!, exchange, env.lowerEnv)),      
      (createExternalAgentClientConfig(payload.brokers!, exchange, env.lowerEnv)),
      (createExternalMCPClientConfig(payload.brokers!, mcpResolver, exchange, env.lowerEnv)),            
      (createBrokersFlows(payload.brokers!))
    }
}
