/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.agent.generator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.networknt.schema.AbsoluteIri;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.resource.InputStreamSource;
import com.networknt.schema.resource.SchemaLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.weave.v2.model.ServiceManager;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ScriptingBindings;
import scala.Option;

public class MuleAppGenerator {
    public static final String MULE_ARTIFACT_JSON = "mule-artifact.json";
    public static final String LOG4J_CONFIG = "app-log4j.xml-template";
    public static final String MULE_AGENT_XML = "mule-agent.xml";
    public static final String APPLICATION_YAML = "application/yaml";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_JAVA = "application/java";
    public static final String MVNW_CMD = "mvnw.cmd";
    public static final String MVNW = "mvnw";
    public static final String MAVEN_WRAPPER_PROPERTIES = "maven-wrapper.properties";
    public static final String GENERATE = "generate";
    public static final String VALIDATE = "validate";
    private DataWeaveScriptingEngine dataWeaveScriptingEngine = new DataWeaveScriptingEngine();

    public void validateMainFile(File mainFile) {
        JsonSchemaFactory factory = JsonSchemaFactory.getInstance(SpecVersion.VersionFlag.V202012, builder -> builder.schemaLoaders(loader -> loader.add(new ClassLoaderSchemaLoader())));
        try (InputStream schemaStream = this.getClass().getClassLoader().getResourceAsStream("agent_network.json");){
            ObjectMapper yamlMapper;
            JsonNode jsonNode;
            if (schemaStream == null) {
                throw new RuntimeException("Could not find agent_network.json on the classpath. Ensure the 'schema' module is a dependency.");
            }
            SchemaValidatorsConfig config = SchemaValidatorsConfig.builder().build();
            JsonSchema jsonSchema = factory.getSchema(schemaStream, config);
            Set<ValidationMessage> errors = jsonSchema.validate(jsonNode = (yamlMapper = new ObjectMapper(new YAMLFactory())).readTree(mainFile));
            if (!errors.isEmpty()) {
                String errorMessages = errors.stream().map(ValidationMessage::toString).collect(Collectors.joining("\n- ", "\n- ", ""));
                throw new RuntimeException("The " + mainFile.getName() + " file is not valid according to the schema:" + errorMessages);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("An error occurred during schema validation.", e);
        }
    }

    public void generateMuleApp(File mainFile, File exchangeJsonFile, Boolean lowerEnv, File outputDirectory) {
        try {
            FileOutputStream mvnwOut;
            File file;
            outputDirectory.mkdirs();
            DataWeaveScript muleAppGenerator = this.dataWeaveScriptingEngine.compile(NameIdentifier.apply("MuleAppGenerator", Option.empty()));
            try (FileInputStream fabricFileStream = new FileInputStream(mainFile);){
                File srcMuleDir = new File(outputDirectory, "src" + File.separator + "main" + File.separator + "mule");
                srcMuleDir.mkdirs();
                File outputFile = new File(srcMuleDir, MULE_AGENT_XML);
                ScriptingBindings bindings = new ScriptingBindings().addBinding("payload", (Object)fabricFileStream, APPLICATION_YAML).addBinding("exchange", (Object)exchangeJsonFile, APPLICATION_JSON).addBinding("env", Map.of("lowerEnv", lowerEnv), APPLICATION_JAVA);
                muleAppGenerator.write(bindings, ServiceManager.apply(), Option.apply(outputFile));
            }
            File resourcesMuleDir = new File(outputDirectory, "src" + File.separator + "main" + File.separator + "resources");
            resourcesMuleDir.mkdirs();
            DataWeaveScript configYaml = this.dataWeaveScriptingEngine.compile(NameIdentifier.apply("MuleAppConfigGenerator", Option.empty()));
            try (FileInputStream exchangeJsonStream = new FileInputStream(exchangeJsonFile);){
                File outputFile = new File(resourcesMuleDir, "config.yaml");
                ScriptingBindings bindings = new ScriptingBindings().addBinding("payload", (Object)exchangeJsonStream, APPLICATION_JSON).addBinding("port", (Object)8081, APPLICATION_JAVA).addBinding("agentGW", (Object)"http://localhost:8081", APPLICATION_JAVA);
                configYaml.write(bindings, ServiceManager.apply(), Option.apply(outputFile));
            }
            this.writeResource(LOG4J_CONFIG, new File(resourcesMuleDir, "log4j2.xml"));
            DataWeaveScript pomGenerator = this.dataWeaveScriptingEngine.compile(NameIdentifier.apply("MuleAppPomGenerator", Option.empty()));
            try (FileInputStream exchangeJsonStream = new FileInputStream(exchangeJsonFile);){
                File pom = new File(outputDirectory, "pom.xml");
                ScriptingBindings bindings = new ScriptingBindings().addBinding("payload", (Object)exchangeJsonStream, APPLICATION_JSON);
                pomGenerator.write(bindings, ServiceManager.apply(), Option.apply(pom));
            }
            this.writeResource(MULE_ARTIFACT_JSON, new File(outputDirectory, MULE_ARTIFACT_JSON));
            try (InputStream mvnw = this.getClass().getClassLoader().getResourceAsStream(MVNW);){
                assert (mvnw != null);
                file = new File(outputDirectory, MVNW);
                mvnwOut = new FileOutputStream(file);
                try {
                    ((OutputStream)mvnwOut).write(mvnw.readAllBytes());
                    file.setExecutable(true);
                }
                finally {
                    ((OutputStream)mvnwOut).close();
                }
            }
            try (InputStream mavenWrapper = this.getClass().getClassLoader().getResourceAsStream(MAVEN_WRAPPER_PROPERTIES);){
                assert (mavenWrapper != null);
                File parent = new File(outputDirectory, ".mvn" + File.separator + "wrapper");
                parent.mkdirs();
                File file2 = new File(parent, MAVEN_WRAPPER_PROPERTIES);
                try (FileOutputStream mvnwOut2 = new FileOutputStream(file2);){
                    ((OutputStream)mvnwOut2).write(mavenWrapper.readAllBytes());
                }
            }
            mvnw = this.getClass().getClassLoader().getResourceAsStream(MVNW_CMD);
            try {
                assert (mvnw != null);
                file = new File(outputDirectory, MVNW_CMD);
                mvnwOut = new FileOutputStream(file);
                try {
                    ((OutputStream)mvnwOut).write(mvnw.readAllBytes());
                    file.setExecutable(true);
                }
                finally {
                    ((OutputStream)mvnwOut).close();
                }
            }
            finally {
                if (mvnw != null) {
                    mvnw.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeResource(String resourcePath, File outputFile) throws Exception {
        try (InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(resourcePath);){
            assert (resourceAsStream != null);
            try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
                ((OutputStream)outputStream).write(resourceAsStream.readAllBytes());
            }
        }
    }

    public static void main(String[] args) {
        MuleAppGenerator muleAppGenerator = new MuleAppGenerator();
        String command = args[0];
        if (command.equalsIgnoreCase(GENERATE)) {
            muleAppGenerator.generateMuleApp(new File(args[1]), new File(args[2]), Boolean.parseBoolean(args[3]), new File(args[4]));
            System.out.println("Brokers generated successfully");
        } else if (command.equalsIgnoreCase(VALIDATE) && args.length == 2) {
            muleAppGenerator.validateMainFile(new File(args[1]));
        } else {
            throw new IllegalArgumentException("Usage: <generate|validate> <mainFile> <exchangeJsonFile> <lowerEnv> <outputDirectory> ");
        }
    }

    private static class ClassLoaderSchemaLoader
    implements SchemaLoader {
        private ClassLoaderSchemaLoader() {
        }

        @Override
        public InputStreamSource getSchema(AbsoluteIri absoluteIri) {
            String iri = absoluteIri != null ? absoluteIri.toString() : "";
            ClassLoader classLoader = this.getClass().getClassLoader();
            return () -> {
                InputStream result = classLoader.getResourceAsStream(iri);
                if (result == null) {
                    result = classLoader.getResourceAsStream(iri.substring(1));
                }
                return result;
            };
        }
    }
}

