/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.model.values.coercion;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.Locale;
import org.mule.weave.v2.core.exception.UnsupportedTypeCoercionException;
import org.mule.weave.v2.core.exception.UnsupportedTypeCoercionException$;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.types.DateTimeType$;
import org.mule.weave.v2.model.types.LocalDateTimeType$;
import org.mule.weave.v2.model.types.LocalTimeType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.TimeType$;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.values.LocalTimeValue;
import org.mule.weave.v2.model.values.LocalTimeValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.coercion.TemporalCoercer;
import org.mule.weave.v2.model.values.coercion.ValueCoercer;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function0;
import scala.Option;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

public final class LocalTimeCoercer$
implements ValueCoercer<LocalTimeValue>,
TemporalCoercer<LocalTime> {
    public static LocalTimeCoercer$ MODULE$;
    private final TemporalQuery<LocalTime> FROM;

    static {
        new LocalTimeCoercer$();
    }

    @Override
    public Object stringCoercion(CharSequence str, TemporalQuery from, LocationCapable locationCapable, Option schema, EvaluationContext ctx) {
        return TemporalCoercer.stringCoercion$(this, str, from, locationCapable, schema, ctx);
    }

    @Override
    public Object parseTemporal(CharSequence str, String format, Locale locale, Option mode, TemporalQuery from, LocationCapable locationCapable, EvaluationContext ctx) {
        return TemporalCoercer.parseTemporal$(this, str, format, locale, mode, from, locationCapable, ctx);
    }

    @Override
    public Option<LocalTimeValue> coerceMaybe(Value<?> value, Option<Schema> targetSchema, LocationCapable locationCapable, EvaluationContext evaluationContext) {
        return ValueCoercer.coerceMaybe$(this, value, targetSchema, locationCapable, evaluationContext);
    }

    public TemporalQuery<LocalTime> FROM() {
        return this.FROM;
    }

    @Override
    public LocalTimeValue coerce(Value<?> c, Option<Schema> targetSchema, LocationCapable locationCapable, EvaluationContext ctx) {
        LocalTime localTime;
        Value<?> value = c;
        if (LocalTimeType$.MODULE$.accepts(value, ctx)) {
            localTime = (LocalTime)c.evaluate(ctx);
        } else if (DateTimeType$.MODULE$.accepts(value, ctx)) {
            localTime = ((ZonedDateTime)c.evaluate(ctx)).toLocalTime();
        } else if (LocalDateTimeType$.MODULE$.accepts(value, ctx)) {
            localTime = ((LocalDateTime)c.evaluate(ctx)).toLocalTime();
        } else if (TimeType$.MODULE$.accepts(value, ctx)) {
            localTime = ((OffsetTime)c.evaluate(ctx)).toLocalTime();
        } else if (StringType$.MODULE$.accepts(value, ctx)) {
            localTime = (LocalTime)this.stringCoercion((CharSequence)c.evaluate(ctx), this.FROM(), locationCapable, (Option)targetSchema, ctx);
        } else {
            throw UnsupportedTypeCoercionException$.MODULE$.apply(locationCapable.location(), c.valueType(ctx), LocalTimeType$.MODULE$.withSchema(targetSchema), c, ctx);
        }
        LocalTime coercedValue = localTime;
        return LocalTimeValue$.MODULE$.apply(coercedValue, locationCapable, targetSchema);
    }

    @Override
    public LocalTime fallbackStringCoercion(CharSequence str, LocationCapable locationCapable, EvaluationContext ctx) {
        return (LocalTime)Try$.MODULE$.apply((Function0<LocalTime> & Serializable & scala.Serializable)() -> ZonedDateTime.parse(str).toLocalTime()).orElse((Function0<Try> & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0<LocalTime> & Serializable & scala.Serializable)() -> LocalDateTime.parse(str).toLocalTime())).orElse((Function0<Try> & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0<LocalTime> & Serializable & scala.Serializable)() -> OffsetTime.parse(str).toLocalTime())).orElse((Function0<Try> & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0<LocalTime> & Serializable & scala.Serializable)() -> LocalTime.parse(str))).orElse((Function0<Failure> & Serializable & scala.Serializable)() -> new Failure(new UnsupportedTypeCoercionException(locationCapable.location(), StringType$.MODULE$, LocalTimeType$.MODULE$, (Function0<String> & Serializable & scala.Serializable)() -> ((Object)str).toString(), UnsupportedTypeCoercionException$.MODULE$.$lessinit$greater$default$5(), UnsupportedTypeCoercionException$.MODULE$.$lessinit$greater$default$6(), ctx))).get();
    }

    @Override
    public Type targetType() {
        return LocalTimeType$.MODULE$;
    }

    private LocalTimeCoercer$() {
        MODULE$ = this;
        ValueCoercer.$init$(this);
        TemporalCoercer.$init$(this);
        this.FROM = new TemporalQuery<LocalTime>(){

            public LocalTime queryFrom(TemporalAccessor temporal) {
                return LocalTime.from(temporal);
            }
        };
    }
}

